/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.tropical_fish;

import com.dragn0007.dragnlivestock.entities.util.AbstractSchoolingOFish;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.tropical_fish.OTropicalFishMarkingLayer;
import com.dragn0007.dragnpets.entities.tropical_fish.OTropicalFishModel;
import com.dragn0007.dragnpets.items.POItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OTropicalFish
extends AbstractSchoolingOFish
implements GeoEntity {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnpets", "entities/o_tropical_fish");
    public static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/tropical_fish");
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(OTropicalFish.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(OTropicalFish.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OTropicalFish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OTropicalFish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SPECIES = SynchedEntityData.m_135353_(OTropicalFish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OTropicalFish(EntityType<? extends OTropicalFish> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public OTropicalFish getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (OTropicalFish)((EntityType)POEntityTypes.O_TROPICAL_FISH_ENTITY.get()).m_20615_((Level)serverLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0);
    }

    public int getMaxSchoolSize() {
        return 5;
    }

    public void m_6872_(ItemStack itemStack) {
        super.m_6872_(itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128405_("Variant", this.getVariant());
        compoundTag.m_128405_("Overlay", this.getOverlay());
        compoundTag.m_128405_("Species", this.getSpecies());
        compoundTag.m_128405_("Age", this.m_146764_());
    }

    public void m_142278_(CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
        this.setVariant(compoundTag.m_128451_("Variant"));
        this.setOverlay(compoundTag.m_128451_("Overlay"));
        this.setSpecies(compoundTag.m_128451_("Species"));
        if (compoundTag.m_128441_("Age")) {
            this.m_146762_(compoundTag.m_128451_("Age"));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setOverlay(this.getOverlay() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlay(this.getOverlay() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)POItems.O_TROPICAL_FISH_BUCKET.get());
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    public SoundEvent m_7975_(DamageSource p_29795_) {
        return SoundEvents.f_12529_;
    }

    public SoundEvent getFlopSound() {
        return SoundEvents.f_12528_;
    }

    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (!this.m_20069_()) {
            controller.setAnimation(RawAnimation.begin().then("flop", Animation.LoopType.LOOP));
        }
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("swim_sprint", Animation.LoopType.LOOP));
            } else if (currentSpeed < speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(OTropicalFishModel.Variant.values().length));
        this.setOverlay(random.nextInt(OTropicalFishMarkingLayer.Overlay.values().length));
        this.setSpecies(random.nextInt(Species.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public String getDynamicResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    public String getDynamicOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public ResourceLocation getTextureResource() {
        return OTropicalFishModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public ResourceLocation getOverlayResource() {
        return OTropicalFishMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlay()).resourceLocation;
    }

    public ResourceLocation getSpeciesResource() {
        return Species.speciesfromordinal((int)this.getSpecies()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)OTropicalFishModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getOverlay() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlay(int overlay) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)OTropicalFishMarkingLayer.Overlay.overlayFromOrdinal((int)overlay).resourceLocation.toString());
        this.f_19804_.m_135381_(OVERLAY, (Object)overlay);
    }

    public int getSpecies() {
        return (Integer)this.f_19804_.m_135370_(SPECIES);
    }

    public void setSpecies(int species) {
        this.f_19804_.m_135381_(SPECIES, (Object)species);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlay(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Species")) {
            this.setSpecies(tag.m_128451_("Species"));
        }
        if (tag.m_128441_("Variant_Texture")) {
            this.setVariantTexture(tag.m_128461_("Variant_Texture"));
        }
        if (tag.m_128441_("Overlay_Texture")) {
            this.setOverlayVariantTexture(tag.m_128461_("Overlay_Texture"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlay());
        tag.m_128405_("Species", this.getSpecies());
        tag.m_128359_("Variant_Texture", this.getTextureResource().toString());
        tag.m_128359_("Overlay_Texture", this.getOverlayResource().toString());
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(SPECIES, (Object)0);
        this.f_19804_.m_135372_(VARIANT_TEXTURE, (Object)OTropicalFishModel.Variant.BLACK.resourceLocation.toString());
        this.f_19804_.m_135372_(OVERLAY_TEXTURE, (Object)OTropicalFishMarkingLayer.Overlay.NONE.resourceLocation.toString());
    }

    public static enum Species {
        SMALL(new ResourceLocation("dragnpets", "geo/tropical_fish_small.geo.json")),
        MEDIUM(new ResourceLocation("dragnpets", "geo/tropical_fish.geo.json")),
        LARGE(new ResourceLocation("dragnpets", "geo/tropical_fish_large.geo.json"));

        public final ResourceLocation resourceLocation;

        private Species(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Species speciesfromordinal(int ordinal) {
            return Species.values()[ordinal % Species.values().length];
        }
    }
}

