/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.wolf;

import com.dragn0007.dragnpets.entities.wolf.OWolf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OWolfModel
extends DefaultedEntityGeoModel<OWolf> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/o_wolf.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/o_wolf.animation.json");

    public OWolfModel() {
        super(new ResourceLocation("dragnlivestock", "o_wolf"), true);
    }

    public void setCustomAnimations(OWolf animatable, long instanceId, AnimationState<OWolf> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OWolf object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OWolf object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OWolf animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnpets", "textures/entity/wolf/black.png")),
        BROWN(new ResourceLocation("dragnpets", "textures/entity/wolf/brown.png")),
        CHOCOLATE(new ResourceLocation("dragnpets", "textures/entity/wolf/chocolate.png")),
        CREAM(new ResourceLocation("dragnpets", "textures/entity/wolf/cream.png")),
        GREY(new ResourceLocation("dragnpets", "textures/entity/wolf/grey.png")),
        MAHOGANY(new ResourceLocation("dragnpets", "textures/entity/wolf/mahogany.png")),
        RED(new ResourceLocation("dragnpets", "textures/entity/wolf/red.png")),
        TIMBER(new ResourceLocation("dragnpets", "textures/entity/wolf/timber.png")),
        WHITE(new ResourceLocation("dragnpets", "textures/entity/wolf/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

