/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen.server;

import com.shynieke.geore.Reference;
import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class GeOreBlockTagsProvider
extends BlockTagsProvider {
    public GeOreBlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, "geore", existingFileHelper);
    }

    private static TagKey<Block> modTag(String name) {
        return BlockTags.create((ResourceLocation)Reference.modLoc(name));
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (GeOreBlockReg reg : GeOreRegistry.getGeOres()) {
            this.addMineable(reg);
            this.addCrystalSounds(reg);
            this.addGeore(reg);
            this.tag(Tags.Blocks.GLASS_BLOCKS_TINTED).add((Object)((Block)reg.getTintedGlass().get()));
            this.tag(Tags.Blocks.RELOCATION_NOT_SUPPORTED).add((Object)((Block)reg.getBudding().get()));
        }
    }

    private void addMineable(GeOreBlockReg blockReg) {
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)blockReg.getCluster().get())).add((Object)((Block)blockReg.getSmallBud().get())).add((Object)((Block)blockReg.getMediumBud().get())).add((Object)((Block)blockReg.getLargeBud().get())).add((Object)((Block)blockReg.getBlock().get())).add((Object)((Block)blockReg.getBudding().get()));
    }

    private void addCrystalSounds(GeOreBlockReg blockReg) {
        this.tag(BlockTags.CRYSTAL_SOUND_BLOCKS).add((Object)((Block)blockReg.getBlock().get())).add((Object)((Block)blockReg.getBudding().get()));
    }

    private void addGeore(GeOreBlockReg blockReg) {
        TagKey<Block> budsTag = GeOreBlockTagsProvider.modTag("buds/geore_" + blockReg.getName());
        this.tag(budsTag).add((Object[])new Block[]{(Block)blockReg.getSmallBud().get(), (Block)blockReg.getMediumBud().get(), (Block)blockReg.getLargeBud().get()});
        this.tag(Tags.Blocks.BUDS).addTag(budsTag);
        TagKey<Block> clustersTag = GeOreBlockTagsProvider.modTag("clusters/geore_" + blockReg.getName());
        this.tag(clustersTag).add((Object)((Block)blockReg.getCluster().get()));
        this.tag(Tags.Blocks.CLUSTERS).addTag(clustersTag);
        this.tag(Tags.Blocks.BUDDING_BLOCKS).add((Object)((Block)blockReg.getBudding().get()));
        TagKey<Block> blockTag = GeOreBlockTagsProvider.modTag("storage_blocks/geore_" + blockReg.getName());
        this.tag(blockTag).add((Object)((Block)blockReg.getBlock().get()));
    }
}

