/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.features;

import com.shynieke.geore.config.GeOreConfig;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public enum ConfigFeature {
    FALSE("invalid", () -> false),
    COAL_GEORE("coal", (Supplier<Boolean>)GeOreConfig.COMMON.generateCoalGeore),
    COPPER_GEORE("copper", (Supplier<Boolean>)GeOreConfig.COMMON.generateCopperGeore),
    DIAMOND_GEORE("diamond", (Supplier<Boolean>)GeOreConfig.COMMON.generateDiamondGeore),
    EMERALD_GEORE("emerald", (Supplier<Boolean>)GeOreConfig.COMMON.generateEmeraldGeore),
    GOLD_GEORE("gold", (Supplier<Boolean>)GeOreConfig.COMMON.generateGoldGeore),
    IRON_GEORE("iron", (Supplier<Boolean>)GeOreConfig.COMMON.generateIronGeore),
    LAPIS_GEORE("lapis", (Supplier<Boolean>)GeOreConfig.COMMON.generateLapisGeore),
    QUARTZ_GEORE("quartz", (Supplier<Boolean>)GeOreConfig.COMMON.generateQuartzGeore),
    QUARTZ_NETHER_GEORE("quartz_nether", (Supplier<Boolean>)GeOreConfig.COMMON.generateQuartzInNetherGeore),
    REDSTONE_GEORE("redstone", (Supplier<Boolean>)GeOreConfig.COMMON.generateRedstoneGeore),
    ANCIENT_DEBRIS_GEORE("ancient_debris", (Supplier<Boolean>)GeOreConfig.COMMON.generateBuddingAncientDebris),
    RUBY_GEORE("ruby", (Supplier<Boolean>)GeOreConfig.COMMON.generateRubyGeore),
    SAPPHIRE_GEORE("sapphire", (Supplier<Boolean>)GeOreConfig.COMMON.generateSapphireGeore),
    TOPAZ_GEORE("topaz", (Supplier<Boolean>)GeOreConfig.COMMON.generateTopazGeore),
    ZINC_GEORE("zinc", (Supplier<Boolean>)GeOreConfig.COMMON.generateZincGeore),
    URANINITE_GEORE("uraninite", (Supplier<Boolean>)GeOreConfig.COMMON.generateUraniniteGeore),
    BLACK_QUARTZ_GEORE("black_quartz", (Supplier<Boolean>)GeOreConfig.COMMON.generateBlackQuartzGeore),
    MONAZITE_GEORE("monazite", (Supplier<Boolean>)GeOreConfig.COMMON.generateMonaziteGeore),
    ALUMINUM_GEORE("aluminum", (Supplier<Boolean>)GeOreConfig.COMMON.generateAluminumGeore),
    LEAD_GEORE("lead", (Supplier<Boolean>)GeOreConfig.COMMON.generateLeadGeore),
    NICKEL_GEORE("nickel", (Supplier<Boolean>)GeOreConfig.COMMON.generateNickelGeore),
    OSMIUM_GEORE("osmium", (Supplier<Boolean>)GeOreConfig.COMMON.generateOsmiumGeore),
    PLATINUM_GEORE("platinum", (Supplier<Boolean>)GeOreConfig.COMMON.generatePlatinumGeore),
    SILVER_GEORE("silver", (Supplier<Boolean>)GeOreConfig.COMMON.generateSilverGeore),
    TIN_GEORE("tin", (Supplier<Boolean>)GeOreConfig.COMMON.generateTinGeore),
    TUNGSTEN_GEORE("tungsten", (Supplier<Boolean>)GeOreConfig.COMMON.generateTungstenGeore),
    URANIUM_GEORE("uranium", (Supplier<Boolean>)GeOreConfig.COMMON.generateUraniumGeore);

    public final String name;
    public final Supplier<Boolean> configValue;

    private ConfigFeature(String name, Supplier<Boolean> configValue) {
        this.name = name;
        this.configValue = configValue;
    }

    public boolean getValue() {
        return this.configValue.get();
    }

    @NotNull
    public static ConfigFeature getByName(@Nullable String value) {
        for (ConfigFeature captcha : ConfigFeature.values()) {
            if (!captcha.name.equals(value)) continue;
            return captcha;
        }
        return FALSE;
    }
}

