/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RibbitWaterCropsGoal
extends Goal {
    private static final int TICKS_TO_WATER = 34;
    private final RibbitEntity ribbit;
    private final double range;
    private final int cooldownTicks;
    private final float speedModifier;
    private BlockPos targetCropPos;
    private int wateringTicks = 0;

    public RibbitWaterCropsGoal(RibbitEntity ribbit, double range, float speedModifier, int cooldownTicks) {
        this.ribbit = ribbit;
        this.range = range;
        this.speedModifier = speedModifier;
        this.cooldownTicks = cooldownTicks;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void start() {
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.ribbit.getNavigation().moveTo((double)((float)this.targetCropPos.getX() + 0.5f), (double)this.targetCropPos.getY(), (double)((float)this.targetCropPos.getZ() + 0.5f), (double)(this.speedModifier * waterModifier));
    }

    public void stop() {
        this.wateringTicks = 0;
        this.ribbit.setWatering(false);
        this.targetCropPos = null;
        this.ribbit.setBuffCooldown(this.cooldownTicks);
    }

    public boolean canUse() {
        if (this.ribbit.level().isNight()) {
            return false;
        }
        Optional cropPos = BlockPos.findClosestMatch((BlockPos)this.ribbit.getOnPos(), (int)((int)this.range), (int)5, blockPos -> RibbitWaterCropsGoal.isValidCropBlock((LevelReader)this.ribbit.level(), blockPos, this.ribbit.level().getBlockState(blockPos)) && this.ribbit.getBuffCooldown() == 0);
        cropPos.ifPresent(blockPos -> {
            this.targetCropPos = blockPos;
        });
        return this.ribbit.getBuffCooldown() == 0 && cropPos.isPresent();
    }

    public boolean canContinueToUse() {
        if (this.wateringTicks < 0) {
            return false;
        }
        boolean cropNearby = false;
        for (BlockPos nearbyPos : this.getNearbyPositions()) {
            if (!RibbitWaterCropsGoal.isValidCropBlock((LevelReader)this.ribbit.level(), nearbyPos, this.ribbit.level().getBlockState(nearbyPos))) continue;
            cropNearby = true;
            break;
        }
        return this.ribbit.distanceToSqr((float)this.targetCropPos.getX() + 0.5f, this.targetCropPos.getY(), (float)this.targetCropPos.getZ() + 0.5f) > 1.0 || cropNearby || this.wateringTicks > 0;
    }

    public boolean isInterruptable() {
        return this.wateringTicks < 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.wateringTicks < 0) {
            return;
        }
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.ribbit.getNavigation().setSpeedModifier((double)(this.speedModifier * waterModifier));
        if (this.ribbit.distanceToSqr((float)this.targetCropPos.getX() + 0.5f, this.targetCropPos.getY(), (float)this.targetCropPos.getZ() + 0.5f) < 2.0) {
            if (this.wateringTicks == 0) {
                this.ribbit.getLookControl().setLookAt((double)((float)this.targetCropPos.getX() + 0.5f), this.ribbit.getEyeY(), (double)((float)this.targetCropPos.getZ() + 0.5f));
            }
            this.ribbit.getNavigation().stop();
            this.ribbit.setWatering(true);
            ++this.wateringTicks;
            if (this.wateringTicks >= 34) {
                for (BlockPos pos : this.getNearbyPositions()) {
                    RibbitWaterCropsGoal.tryGrowCropAtPos(this.ribbit.level(), pos);
                }
                this.wateringTicks = -1;
            }
        } else if (this.ribbit.distanceToSqr((float)this.targetCropPos.getX() + 0.5f, this.targetCropPos.getY(), (float)this.targetCropPos.getZ() + 0.5f) < 3.0) {
            this.ribbit.setWatering(false);
            this.ribbit.getMoveControl().setWantedPosition((double)((float)this.targetCropPos.getX() + 0.5f), (double)this.targetCropPos.getY(), (double)((float)this.targetCropPos.getZ() + 0.5f), (double)(this.speedModifier * waterModifier));
        } else {
            this.ribbit.setWatering(false);
            this.ribbit.getNavigation().moveTo((double)((float)this.targetCropPos.getX() + 0.5f), (double)this.targetCropPos.getY(), (double)((float)this.targetCropPos.getZ() + 0.5f), (double)(this.speedModifier * waterModifier));
        }
    }

    private static void tryGrowCropAtPos(Level level, BlockPos pos) {
        BonemealableBlock bonemealableBlock;
        Block block;
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(BlockTags.CROPS) && (block = blockState.getBlock()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, blockState) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (bonemealableBlock.isBonemealSuccess(level, level.random, pos, blockState)) {
                bonemealableBlock.performBonemeal(serverLevel, level.random, pos, blockState);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FALLING_WATER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 8, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean isValidCropBlock(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        BonemealableBlock bonemealableBlock;
        Block block;
        return blockState.is(BlockTags.CROPS) && (block = blockState.getBlock()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget(levelReader, blockPos, blockState);
    }

    private Iterable<BlockPos> getNearbyPositions() {
        return BlockPos.betweenClosed((int)Mth.floor((double)(this.ribbit.getX() - 1.0)), (int)Mth.floor((double)(this.ribbit.getY() - 1.0)), (int)Mth.floor((double)(this.ribbit.getZ() - 1.0)), (int)Mth.floor((double)(this.ribbit.getX() + 1.0)), (int)Mth.floor((double)((double)this.ribbit.getBlockY() + 1.0)), (int)Mth.floor((double)(this.ribbit.getZ() + 1.0)));
    }
}

