/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.item;

import com.yungnickyoung.minecraft.ribbits.data.RibbitData;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.item.RibbitSpawnEggDispenseItemBehaviorNeoForge;
import com.yungnickyoung.minecraft.ribbits.module.RibbitUmbrellaTypeModule;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RibbitSpawnEggItemNeoForge
extends DeferredSpawnEggItem {
    private static final DispenseItemBehavior RIBBIT_DISPENSER_BEHAVIOR = new RibbitSpawnEggDispenseItemBehaviorNeoForge();
    private final RibbitProfession profession;

    public RibbitSpawnEggItemNeoForge(EntityType<RibbitEntity> entityType, RibbitProfession profession, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(() -> entityType, backgroundColor, highlightColor, properties);
        this.profession = profession;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockEntity blockEntity;
        Level level = useOnContext.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useOnContext.getItemInHand();
        BlockPos blockPos = useOnContext.getClickedPos();
        Direction direction = useOnContext.getClickedFace();
        BlockState blockState = level.getBlockState(blockPos);
        EntityType entityType = this.getType(itemStack);
        if (blockState.is(Blocks.SPAWNER) && (blockEntity = level.getBlockEntity(blockPos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            spawnerBlockEntity.setEntityId(entityType, level.getRandom());
            blockEntity.setChanged();
            level.sendBlockUpdated(blockPos, blockState, blockState, 3);
            level.gameEvent((Entity)useOnContext.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, blockPos);
            itemStack.shrink(1);
            return InteractionResult.CONSUME;
        }
        BlockPos spawnPos = blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
        RibbitEntity ribbit = (RibbitEntity)entityType.spawn((ServerLevel)level, itemStack, useOnContext.getPlayer(), spawnPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, spawnPos) && direction == Direction.UP);
        if (ribbit != null) {
            ribbit.setRibbitData(new RibbitData(this.profession, RibbitUmbrellaTypeModule.getRandomUmbrellaType(), ribbit.getRibbitData().getInstrument()));
            itemStack.shrink(1);
            level.gameEvent((Entity)useOnContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockPos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = SpawnEggItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (!(level.getBlockState(blockPos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (!level.mayInteract(player, blockPos) || !player.mayUseItemAt(blockPos, blockHitResult.getDirection(), itemStack)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        EntityType entityType = this.getType(itemStack);
        RibbitEntity ribbit = (RibbitEntity)entityType.spawn((ServerLevel)level, itemStack, player, blockPos, MobSpawnType.SPAWN_EGG, false, false);
        if (ribbit == null) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        ribbit.setRibbitData(new RibbitData(this.profession, RibbitUmbrellaTypeModule.getRandomUmbrellaType(), ribbit.getRibbitData().getInstrument()));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, ribbit.position());
        return InteractionResultHolder.consume((Object)itemStack);
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return RIBBIT_DISPENSER_BEHAVIOR;
    }

    public RibbitProfession getProfession() {
        return this.profession;
    }
}

