/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.ribbits.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BrewingStandProcessor
extends StructureProcessor {
    public static final BrewingStandProcessor INSTANCE = new BrewingStandProcessor();
    public static final MapCodec<BrewingStandProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().getBlock() == Blocks.BREWING_STAND) {
            RandomSource randomSource = structurePlacementData.getRandom(blockInfoGlobal.pos());
            CompoundTag tag = blockInfoGlobal.nbt();
            ListTag itemsListTag = tag.getList("Items", 10);
            this.populateItemsList(itemsListTag, randomSource);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), blockInfoGlobal.state(), tag);
        }
        return blockInfoGlobal;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.BREWING_STAND_PROCESSOR;
    }

    private void populateItemsList(ListTag itemsListTag, RandomSource randomSource) {
        int n = randomSource.nextInt(5);
        switch (n) {
            case 1: {
                this.addBrewingRecipe(itemsListTag, "minecraft:sugar", "minecraft:swiftness", 4, 0.5f, randomSource);
                break;
            }
            case 2: {
                this.addBrewingRecipe(itemsListTag, "minecraft:pufferfish", "minecraft:water_breathing", 3, 0.5f, randomSource);
                break;
            }
            case 3: {
                this.addBrewingRecipe(itemsListTag, "minecraft:phantom_membrane", "minecraft:slow_falling", 1, 0.4f, randomSource);
                break;
            }
            case 4: {
                this.addBrewingRecipe(itemsListTag, "minecraft:rabbit_foot", "minecraft:leaping", 1, 0.25f, randomSource);
            }
        }
    }

    private void addBrewingRecipe(ListTag itemsListTag, String inputItemId, String outputPotionId, int maxInputCount, float bonusOutputChance, RandomSource randomSource) {
        itemsListTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), itemTag -> this.putInputItem((CompoundTag)itemTag, inputItemId, (byte)(randomSource.nextInt(maxInputCount) + 1)))));
        itemsListTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), itemTag -> this.putPotionInSlot((CompoundTag)itemTag, (byte)1, outputPotionId))));
        if (randomSource.nextFloat() < bonusOutputChance) {
            int bonusSlot = randomSource.nextBoolean() ? 0 : 2;
            itemsListTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), itemTag -> this.putPotionInSlot((CompoundTag)itemTag, (byte)bonusSlot, outputPotionId))));
        }
    }

    private void putInputItem(CompoundTag itemTag, String itemId, byte count) {
        itemTag.putByte("Slot", (byte)3);
        itemTag.putString("id", itemId);
        itemTag.putByte("count", count);
    }

    private void putPotionInSlot(CompoundTag itemTag, byte slot, String potionId) {
        itemTag.putByte("Slot", slot);
        itemTag.putString("id", "minecraft:potion");
        itemTag.putByte("count", (byte)1);
        itemTag.put("components", (Tag)Util.make((Object)new CompoundTag(), componentsTag -> componentsTag.put("minecraft:potion_contents", (Tag)Util.make((Object)new CompoundTag(), potionContentsTag -> potionContentsTag.putString("potion", potionId)))));
    }
}

