/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.sound.PlayerInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.RibbitInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.supporters.RibbitOptionsJSON;
import com.yungnickyoung.minecraft.ribbits.client.supporters.SupportersListClient;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.ISoundManagerDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.accessor.ClientLevelAccessor;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import com.yungnickyoung.minecraft.ribbits.network.payload.RequestSupporterHatStatePayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStartMusicAllPayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStartMusicSinglePayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStopMusicSinglePayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.StartHearingMaracaPayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.StopHearingMaracaPayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.ToggleSupporterHatPayloadS2C;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3414;

public class ClientPacketHandlerFabric {
    public static void handleStartMusicSinglePayload(RibbitStartMusicSinglePayload payload, ClientPlayNetworking.Context context) {
        RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)context.player().field_17892).callGetEntities().method_31808(payload.ribbitUUID());
        RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(payload.instrumentId());
        if (ribbit == null) {
            RibbitsCommon.LOGGER.error("Received Start Music payload for a ribbit with UUID {} that doesn't exist!", (Object)payload.ribbitUUID());
            return;
        }
        if (instrument == null) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with null instrument!");
            return;
        }
        if (instrument == RibbitInstrumentModule.NONE) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with NONE instrument!");
            return;
        }
        class_3414 instrumentSoundEvent = instrument.getSoundEvent();
        context.client().execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new RibbitInstrumentSoundInstance(ribbit, payload.tickOffset(), instrumentSoundEvent)));
    }

    public static void handleStartMusicAllPayload(RibbitStartMusicAllPayload payload, ClientPlayNetworking.Context context) {
        if (payload.ribbitUUIDs().size() != payload.instrumentIds().size()) {
            RibbitsCommon.LOGGER.error("Received Start Music All payload with {} ribbits and {} instruments!", (Object)payload.ribbitUUIDs().size(), (Object)payload.instrumentIds().size());
            return;
        }
        for (int i = 0; i < payload.ribbitUUIDs().size(); ++i) {
            RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)context.player().field_17892).callGetEntities().method_31808(payload.ribbitUUIDs().get(i));
            if (ribbit == null) {
                RibbitsCommon.LOGGER.error("Received Start Music All payload for a ribbit with UUID {} that doesn't exist!", (Object)payload.ribbitUUIDs().get(i));
                return;
            }
            RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(payload.instrumentIds().get(i));
            if (instrument == null) {
                RibbitsCommon.LOGGER.error("Tried to play music in receiveStartAll for a ribbit with null instrument!");
                return;
            }
            if (instrument == RibbitInstrumentModule.NONE) {
                RibbitsCommon.LOGGER.error("Tried to play music in receiveStartAll for a ribbit with NONE instrument!");
                return;
            }
            class_3414 instrumentSoundEvent = instrument.getSoundEvent();
            context.client().execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new RibbitInstrumentSoundInstance(ribbit, payload.tickOffset(), instrumentSoundEvent)));
        }
    }

    public static void handleStopMusicSinglePayload(RibbitStopMusicSinglePayload payload, ClientPlayNetworking.Context context) {
        RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)context.player().field_17892).callGetEntities().method_31808(payload.ribbitUUID());
        if (ribbit == null) {
            RibbitsCommon.LOGGER.error("Received Stop Music payload for a ribbit with UUID {} that doesn't exist!", (Object)payload.ribbitUUID());
            return;
        }
        context.client().execute(() -> ((ISoundManagerDuck)class_310.method_1551().method_1483()).ribbits$stopRibbitsMusic(payload.ribbitUUID()));
    }

    public static void handleStartHearingMaracaPayload(StartHearingMaracaPayload payload, ClientPlayNetworking.Context context) {
        class_1297 performer = (class_1297)((ClientLevelAccessor)context.player().field_17892).callGetEntities().method_31808(payload.performerUUID());
        if (performer == null) {
            RibbitsCommon.LOGGER.error("Received Start Maraca payload for Player performer with UUID {} that doesn't exist!", (Object)payload.performerUUID());
            return;
        }
        if (!(performer instanceof class_1657)) {
            RibbitsCommon.LOGGER.error("Received Start Maraca payload for non-Player performer with UUID {}!", (Object)payload.performerUUID());
            return;
        }
        context.client().execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new PlayerInstrumentSoundInstance((class_1657)performer, -1, (class_3414)SoundModule.MUSIC_MARACA.get())));
    }

    public static void handleStopHearingMaracaPayload(StopHearingMaracaPayload payload, ClientPlayNetworking.Context context) {
        class_1297 performer = (class_1297)((ClientLevelAccessor)context.player().field_17892).callGetEntities().method_31808(payload.performerUUID());
        if (performer == null) {
            RibbitsCommon.LOGGER.error("Received Stop Maraca payload for Player performer with UUID {} that doesn't exist!", (Object)payload.performerUUID());
            return;
        }
        if (!(performer instanceof class_1657)) {
            RibbitsCommon.LOGGER.error("Received Stop Maraca payload for non-Player performer with UUID {}!", (Object)payload.performerUUID());
            return;
        }
        context.client().execute(() -> ((ISoundManagerDuck)class_310.method_1551().method_1483()).ribbits$stopMaraca(payload.performerUUID()));
    }

    public static void handleToggleSupporterHatPayload(ToggleSupporterHatPayloadS2C packet, ClientPlayNetworking.Context context) {
        SupportersListClient.toggleSupporterHat(packet.playerUUID(), packet.enabled());
    }

    public static void handleRequestSupporterHatStatePayload(RequestSupporterHatStatePayload payload, ClientPlayNetworking.Context context) {
        SupportersListClient.clear();
        payload.enabledSupporterHatPlayers().forEach(playerUUID -> SupportersListClient.toggleSupporterHat(playerUUID, true));
        Services.SUPPORTER_HELPER.notifyServerOfSupporterHatState(RibbitOptionsJSON.get().isSupporterHatEnabled());
    }
}

