/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.services;

import com.yungnickyoung.minecraft.ribbits.block.GiantLilyPadBlock;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.item.RibbitSpawnEggItemFabric;
import com.yungnickyoung.minecraft.ribbits.module.EntityTypeModule;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStartMusicAllPayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStartMusicSinglePayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStopMusicSinglePayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.StartHearingMaracaPayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.StopHearingMaracaPayload;
import com.yungnickyoung.minecraft.ribbits.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2358;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public void onRibbitStartMusicGoal(class_3218 serverLevel, RibbitEntity newRibbit, RibbitEntity masterRibbit) {
        int tickOffset = newRibbit.equals((Object)masterRibbit) ? masterRibbit.getTicksPlayingMusic() : -1;
        RibbitStartMusicSinglePayload payload = new RibbitStartMusicSinglePayload(newRibbit.method_5667(), newRibbit.getRibbitData().getInstrument().getId(), tickOffset);
        PlayerLookup.all((MinecraftServer)serverLevel.method_8503()).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)payload));
    }

    @Override
    public void onPlayerEnterBandRange(class_3222 player, class_3218 serverLevel, RibbitEntity masterRibbit) {
        List ribbitsPlayingMusic = masterRibbit.getRibbitsPlayingMusic().stream().toList();
        ArrayList<UUID> ribbitIds = new ArrayList<UUID>();
        ribbitIds.add(masterRibbit.method_5667());
        ribbitIds.addAll(ribbitsPlayingMusic.stream().map(class_1297::method_5667).toList());
        ArrayList<class_2960> instrumentIds = new ArrayList<class_2960>();
        instrumentIds.add(masterRibbit.getRibbitData().getInstrument().getId());
        instrumentIds.addAll(ribbitsPlayingMusic.stream().map(ribbit -> ribbit.getRibbitData().getInstrument().getId()).toList());
        RibbitStartMusicAllPayload payload = new RibbitStartMusicAllPayload(ribbitIds, instrumentIds, masterRibbit.getTicksPlayingMusic());
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    @Override
    public void onPlayerExitBandRange(class_3222 player, class_3218 serverLevel, RibbitEntity masterRibbit) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new RibbitStopMusicSinglePayload(masterRibbit.method_5667()));
        for (RibbitEntity ribbit : masterRibbit.getRibbitsPlayingMusic()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new RibbitStopMusicSinglePayload(ribbit.method_5667()));
        }
    }

    @Override
    public void startHearingMaraca(class_3222 performer, class_3222 audienceMember) {
        ServerPlayNetworking.send((class_3222)audienceMember, (class_8710)new StartHearingMaracaPayload(performer.method_5667()));
    }

    @Override
    public void stopHearingMaraca(class_3222 performer, class_3222 audienceMember) {
        ServerPlayNetworking.send((class_3222)audienceMember, (class_8710)new StopHearingMaracaPayload(performer.method_5667()));
    }

    @Override
    public Supplier<class_2248> getGiantLilyPadBlock() {
        return () -> new GiantLilyPadBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9618().method_9626(class_2498.field_25183).method_22488().method_50012(class_3619.field_15971));
    }

    @Override
    public Supplier<class_1792> getRibbitSpawnEggItem(RibbitProfession profession, int backgroundColor, int highlightColor) {
        return () -> new RibbitSpawnEggItemFabric((class_1299<RibbitEntity>)((class_1299)EntityTypeModule.RIBBIT.get()), profession, backgroundColor, highlightColor, new class_1792.class_1793());
    }

    @Override
    public void setBlockAsFlammable(class_2248 block, int igniteChance, int burnChance) {
        class_2358 fireBlock = (class_2358)class_2246.field_10036;
        fireBlock.method_10189(block, igniteChance, burnChance);
    }
}

