/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SwampLanternBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), Block.m_49796_((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)});
    protected static final VoxelShape HANGING_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0), Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0)});

    public SwampLanternBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.m_43725_().m_6425_(placeContext.m_8083_());
        for (Direction direction : placeContext.m_6232_()) {
            BlockState blockState;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockState = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)placeContext.m_43725_(), placeContext.m_8083_())) continue;
            return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.m_61143_((Property)HANGING) != false ? HANGING_AABB : AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{HANGING, WATERLOGGED});
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction $$3 = SwampLanternBlock.getConnectedDirection(blockState).m_122424_();
        return Block.m_49863_((LevelReader)levelReader, (BlockPos)blockPos.m_121945_($$3), (Direction)$$3.m_122424_());
    }

    protected static Direction getConnectedDirection(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborBlockState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return SwampLanternBlock.getConnectedDirection(blockState).m_122424_() == direction && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, neighborBlockState, levelAccessor, blockPos, blockPos1);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }
}

