/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RibbitFishGoal
extends Goal {
    private static final float REQUIRED_DISTANCE_TO_DRY_POS = 0.2f;
    private final RibbitEntity ribbit;
    private final double range;
    private final int minRequiredFishTicks;
    private final int maxRequiredFishTicks;
    private final float speedModifier;
    private int requiredFishTicks;
    private int ticksFishing;
    private BlockPos waterPos;
    private Vec3 dryPos;

    public RibbitFishGoal(RibbitEntity ribbit, double range, float speedModifier, int minRequiredFishTicks, int maxRequiredFishTicks) {
        this.ribbit = ribbit;
        this.range = range;
        this.speedModifier = speedModifier;
        this.minRequiredFishTicks = minRequiredFishTicks;
        this.maxRequiredFishTicks = maxRequiredFishTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void m_8056_() {
        this.requiredFishTicks = this.ribbit.m_217043_().m_216339_(this.minRequiredFishTicks, this.maxRequiredFishTicks);
        this.ticksFishing = 0;
        float waterModifier = this.ribbit.m_20069_() ? 2.0f : 1.0f;
        this.ribbit.m_21573_().m_26519_(this.dryPos.m_7096_(), this.dryPos.m_7098_(), this.dryPos.m_7094_(), (double)(this.speedModifier * waterModifier));
    }

    public void m_8041_() {
        this.waterPos = null;
        this.dryPos = null;
        this.ticksFishing = 0;
        this.ribbit.setFishing(false);
    }

    public boolean m_6767_() {
        return this.ticksFishing >= this.requiredFishTicks;
    }

    public boolean m_8036_() {
        if (this.ribbit.m_9236_().m_46462_()) {
            return false;
        }
        Optional waterPos = BlockPos.m_121930_((BlockPos)this.ribbit.m_20097_(), (int)((int)this.range), (int)5, blockpos -> this.ribbit.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && this.ribbit.m_9236_().m_8055_(blockpos.m_7494_()).m_60713_(Blocks.f_50016_));
        this.dryPos = null;
        if (waterPos.isPresent()) {
            this.waterPos = (BlockPos)waterPos.get();
            for (Direction dir : Direction.Plane.HORIZONTAL.m_235694_(this.ribbit.m_217043_())) {
                BlockPos testedDryPos = this.waterPos.m_121945_(dir);
                if (!this.ribbit.m_9236_().m_8055_(testedDryPos.m_7494_()).m_60713_(Blocks.f_50016_) || !Block.m_49918_((VoxelShape)this.ribbit.m_9236_().m_8055_(testedDryPos).m_60812_((BlockGetter)this.ribbit.m_9236_(), testedDryPos), (Direction)Direction.UP)) continue;
                Vec3 dryPosCenter = new Vec3((double)testedDryPos.m_123341_() + 0.5, (double)testedDryPos.m_123342_() + 1.0, (double)testedDryPos.m_123343_() + 0.5);
                this.dryPos = dryPosCenter.m_82520_((double)(-dir.m_122429_()) * 0.25, 0.0, (double)(-dir.m_122431_()) * 0.25);
                break;
            }
        } else {
            return false;
        }
        if (this.dryPos == null) {
            return false;
        }
        return this.ribbit.m_9236_().m_46461_();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8045_() {
        Iterable nearbyPositions = BlockPos.m_121976_((int)Mth.m_14107_((double)(this.ribbit.m_20185_() - 1.5)), (int)Mth.m_14107_((double)(this.ribbit.m_20186_() - 1.5)), (int)Mth.m_14107_((double)(this.ribbit.m_20189_() - 1.5)), (int)Mth.m_14107_((double)(this.ribbit.m_20185_() + 1.5)), (int)this.ribbit.m_146904_(), (int)Mth.m_14107_((double)(this.ribbit.m_20189_() + 1.5)));
        boolean waterNearby = false;
        for (BlockPos nearbyPos : nearbyPositions) {
            if (!this.ribbit.m_9236_().m_6425_(nearbyPos).m_205070_(FluidTags.f_13131_)) continue;
            waterNearby = true;
            break;
        }
        return this.ribbit.m_20238_(this.dryPos) >= 0.04000000283122063 || waterNearby;
    }

    public void m_8037_() {
        float waterModifier = this.ribbit.m_20069_() ? 2.0f : 1.0f;
        this.ribbit.m_21573_().m_26517_((double)(this.speedModifier * waterModifier));
        if (this.ribbit.m_20238_(this.dryPos) <= 0.04000000283122063) {
            ++this.ticksFishing;
            this.ribbit.setFishing(true);
            this.ribbit.m_21563_().m_24946_((double)((float)this.waterPos.m_123341_() + 0.5f), this.ribbit.m_20188_(), (double)((float)this.waterPos.m_123343_() + 0.5f));
        } else if (this.ribbit.m_20238_(this.dryPos) < 1.0) {
            this.ribbit.setFishing(false);
            this.ribbit.m_21566_().m_6849_(this.dryPos.m_7096_(), this.dryPos.m_7098_(), this.dryPos.m_7094_(), (double)(this.speedModifier * waterModifier));
        } else {
            this.ribbit.setFishing(false);
            this.ribbit.m_21573_().m_26519_(this.dryPos.m_7096_(), this.dryPos.m_7098_(), this.dryPos.m_7094_(), (double)(this.speedModifier * waterModifier));
        }
    }
}

