/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.item;

import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.item.RibbitSpawnEggDispenseItemBehaviorForge;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RibbitSpawnEggItemForge
extends ForgeSpawnEggItem {
    private static final DispenseItemBehavior RIBBIT_DISPENSER_BEHAVIOR = new RibbitSpawnEggDispenseItemBehaviorForge();
    private final RibbitProfession profession;

    public RibbitSpawnEggItemForge(EntityType<RibbitEntity> entityType, RibbitProfession profession, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(() -> entityType, backgroundColor, highlightColor, properties);
        this.profession = profession;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        BlockEntity blockEntity;
        Level level = useOnContext.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useOnContext.m_43722_();
        BlockPos blockPos = useOnContext.m_8083_();
        Direction direction = useOnContext.m_43719_();
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60713_(Blocks.f_50085_) && (blockEntity = level.m_7702_(blockPos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            EntityType entityType = this.m_43228_(itemStack.m_41783_());
            spawnerBlockEntity.m_252803_(entityType, level.m_213780_());
            blockEntity.m_6596_();
            level.m_7260_(blockPos, blockState, blockState, 3);
            level.m_142346_((Entity)useOnContext.m_43723_(), GameEvent.f_157792_, blockPos);
            itemStack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockPos2 = blockState.m_60812_((BlockGetter)level, blockPos).m_83281_() ? blockPos : blockPos.m_121945_(direction);
        EntityType entityType2 = this.m_43228_(itemStack.m_41783_());
        CompoundTag itemTag = itemStack.m_41784_();
        itemTag.m_128359_("Profession", this.profession.toString());
        RibbitEntity ribbit = (RibbitEntity)entityType2.m_20592_((ServerLevel)level, itemStack, useOnContext.m_43723_(), blockPos2, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, blockPos2) && direction == Direction.UP);
        if (ribbit != null) {
            itemStack.m_41774_(1);
            level.m_142346_((Entity)useOnContext.m_43723_(), GameEvent.f_157810_, blockPos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = SpawnEggItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        if (!(level.m_8055_(blockPos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (!level.m_7966_(player, blockPos) || !player.m_36204_(blockPos, blockHitResult.m_82434_(), itemStack)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        EntityType entityType = this.m_43228_(itemStack.m_41783_());
        CompoundTag itemTag = itemStack.m_41784_();
        itemTag.m_128359_("Profession", this.profession.toString());
        RibbitEntity ribbit = (RibbitEntity)entityType.m_20592_((ServerLevel)level, itemStack, player, blockPos, MobSpawnType.SPAWN_EGG, false, false);
        if (ribbit == null) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        level.m_220400_((Entity)player, GameEvent.f_157810_, ribbit.m_20182_());
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return RIBBIT_DISPENSER_BEHAVIOR;
    }

    public RibbitProfession getProfession() {
        return this.profession;
    }
}

