/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public class RibbitWaterCropsGoal
extends class_1352 {
    private static final int TICKS_TO_WATER = 34;
    private final RibbitEntity ribbit;
    private final double range;
    private final int cooldownTicks;
    private final float speedModifier;
    private class_2338 targetCropPos;
    private int wateringTicks = 0;

    public RibbitWaterCropsGoal(RibbitEntity ribbit, double range, float speedModifier, int cooldownTicks) {
        this.ribbit = ribbit;
        this.range = range;
        this.speedModifier = speedModifier;
        this.cooldownTicks = cooldownTicks;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public void method_6269() {
        float waterModifier = this.ribbit.method_5799() ? 2.0f : 1.0f;
        this.ribbit.method_5942().method_6337((double)((float)this.targetCropPos.method_10263() + 0.5f), (double)this.targetCropPos.method_10264(), (double)((float)this.targetCropPos.method_10260() + 0.5f), (double)(this.speedModifier * waterModifier));
    }

    public void method_6270() {
        this.wateringTicks = 0;
        this.ribbit.setWatering(false);
        this.targetCropPos = null;
        this.ribbit.setBuffCooldown(this.cooldownTicks);
    }

    public boolean method_6264() {
        if (this.ribbit.method_37908().method_23886()) {
            return false;
        }
        Optional cropPos = class_2338.method_25997((class_2338)this.ribbit.method_23312(), (int)((int)this.range), (int)5, blockPos -> RibbitWaterCropsGoal.isValidCropBlock((class_4538)this.ribbit.method_37908(), blockPos, this.ribbit.method_37908().method_8320(blockPos)) && this.ribbit.getBuffCooldown() == 0);
        cropPos.ifPresent(blockPos -> {
            this.targetCropPos = blockPos;
        });
        return this.ribbit.getBuffCooldown() == 0 && cropPos.isPresent();
    }

    public boolean method_6266() {
        if (this.wateringTicks < 0) {
            return false;
        }
        boolean cropNearby = false;
        for (class_2338 nearbyPos : this.getNearbyPositions()) {
            if (!RibbitWaterCropsGoal.isValidCropBlock((class_4538)this.ribbit.method_37908(), nearbyPos, this.ribbit.method_37908().method_8320(nearbyPos))) continue;
            cropNearby = true;
            break;
        }
        return this.ribbit.method_5649((float)this.targetCropPos.method_10263() + 0.5f, this.targetCropPos.method_10264(), (float)this.targetCropPos.method_10260() + 0.5f) > 1.0 || cropNearby || this.wateringTicks > 0;
    }

    public boolean method_6267() {
        return this.wateringTicks < 0;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (this.wateringTicks < 0) {
            return;
        }
        float waterModifier = this.ribbit.method_5799() ? 2.0f : 1.0f;
        this.ribbit.method_5942().method_6344((double)(this.speedModifier * waterModifier));
        if (this.ribbit.method_5649((float)this.targetCropPos.method_10263() + 0.5f, this.targetCropPos.method_10264(), (float)this.targetCropPos.method_10260() + 0.5f) < 2.0) {
            if (this.wateringTicks == 0) {
                this.ribbit.method_5988().method_20248((double)((float)this.targetCropPos.method_10263() + 0.5f), this.ribbit.method_23320(), (double)((float)this.targetCropPos.method_10260() + 0.5f));
            }
            this.ribbit.method_5942().method_6340();
            this.ribbit.setWatering(true);
            ++this.wateringTicks;
            if (this.wateringTicks >= 34) {
                for (class_2338 pos : this.getNearbyPositions()) {
                    RibbitWaterCropsGoal.tryGrowCropAtPos(this.ribbit.method_37908(), pos);
                }
                this.wateringTicks = -1;
            }
        } else if (this.ribbit.method_5649((float)this.targetCropPos.method_10263() + 0.5f, this.targetCropPos.method_10264(), (float)this.targetCropPos.method_10260() + 0.5f) < 3.0) {
            this.ribbit.setWatering(false);
            this.ribbit.method_5962().method_6239((double)((float)this.targetCropPos.method_10263() + 0.5f), (double)this.targetCropPos.method_10264(), (double)((float)this.targetCropPos.method_10260() + 0.5f), (double)(this.speedModifier * waterModifier));
        } else {
            this.ribbit.setWatering(false);
            this.ribbit.method_5942().method_6337((double)((float)this.targetCropPos.method_10263() + 0.5f), (double)this.targetCropPos.method_10264(), (double)((float)this.targetCropPos.method_10260() + 0.5f), (double)(this.speedModifier * waterModifier));
        }
    }

    private static void tryGrowCropAtPos(class_1937 level, class_2338 pos) {
        class_2256 bonemealableBlock;
        class_2248 class_22482;
        class_2680 blockState = level.method_8320(pos);
        if (blockState.method_26164(class_3481.field_20341) && (class_22482 = blockState.method_26204()) instanceof class_2256 && (bonemealableBlock = (class_2256)class_22482).method_9651((class_4538)level, pos, blockState, level.field_9236) && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (bonemealableBlock.method_9650(level, level.field_9229, pos, blockState)) {
                bonemealableBlock.method_9652(serverLevel, level.field_9229, pos, blockState);
                serverLevel.method_14199((class_2394)class_2398.field_18306, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.6, (double)pos.method_10260() + 0.5, 8, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean isValidCropBlock(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        class_2256 bonemealableBlock;
        class_2248 class_22482;
        return blockState.method_26164(class_3481.field_20341) && (class_22482 = blockState.method_26204()) instanceof class_2256 && (bonemealableBlock = (class_2256)class_22482).method_9651(levelReader, blockPos, blockState, levelReader.method_8608());
    }

    private Iterable<class_2338> getNearbyPositions() {
        return class_2338.method_10094((int)class_3532.method_15357((double)(this.ribbit.method_23317() - 1.0)), (int)class_3532.method_15357((double)(this.ribbit.method_23318() - 1.0)), (int)class_3532.method_15357((double)(this.ribbit.method_23321() - 1.0)), (int)class_3532.method_15357((double)(this.ribbit.method_23317() + 1.0)), (int)class_3532.method_15357((double)((double)this.ribbit.method_31478() + 1.0)), (int)class_3532.method_15357((double)(this.ribbit.method_23321() + 1.0)));
    }
}

