/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.music;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.sound.InstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.PlayerInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.RibbitInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.IChannelDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.ISoundEngineDuck;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1140;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4231;
import net.minecraft.class_4235;
import net.minecraft.class_4237;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1140.class})
public class SoundEngineMixin
implements ISoundEngineDuck {
    @Shadow
    @Final
    private class_4237 field_18947;
    @Shadow
    @Final
    private List<class_1117> field_5557;

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundBufferLibrary;getCompleteBuffer(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void ribbits$handleRibbitsOffsetSounds(class_1113 soundInstance, CallbackInfo ci, class_1146 $$1x, class_2960 $$2x, class_1111 sound, float $$4x, float $$5x, class_3419 soundSource, float $$7x, float $$8x, class_1113.class_1114 attenuation, boolean $$10x, class_243 $$11x, boolean $$14, boolean $$15, CompletableFuture $$16, class_4235.class_4236 channelAccess) {
        if (soundInstance instanceof InstrumentSoundInstance) {
            InstrumentSoundInstance instrumentSoundInstance = (InstrumentSoundInstance)soundInstance;
            this.playInstrumentSound(sound, channelAccess, instrumentSoundInstance);
            ci.cancel();
        }
    }

    @Unique
    private void playInstrumentSound(class_1111 sound, class_4235.class_4236 channelHandle, InstrumentSoundInstance instrumentSoundInstance) {
        List<InstrumentSoundInstance> soundsToStop = this.field_5557.stream().filter(instance -> instance instanceof InstrumentSoundInstance).map(instance -> (InstrumentSoundInstance)((Object)instance)).filter(instance -> instance.isForSameEntity(instrumentSoundInstance)).toList();
        soundsToStop.forEach(InstrumentSoundInstance::stopSound);
        this.field_18947.method_19743(sound.method_4766()).thenAccept(soundBuffer -> channelHandle.method_19735(channel -> {
            if (instrumentSoundInstance.getTicksOffset() == -1) {
                Optional<Integer> existingSoundSourceId = this.field_5557.stream().filter(instance -> instance instanceof InstrumentSoundInstance && !instance.method_4793() && !instance.equals((Object)instrumentSoundInstance)).map(instance -> ((InstrumentSoundInstance)((Object)((Object)((Object)instance)))).getSourceId()).findAny();
                if (existingSoundSourceId.isPresent()) {
                    ((IChannelDuck)channel).ribbits$attachStaticBufferWithByteOffset((class_1113)instrumentSoundInstance, (class_4231)soundBuffer, existingSoundSourceId.get());
                } else {
                    if (instrumentSoundInstance instanceof RibbitInstrumentSoundInstance) {
                        RibbitsCommon.LOGGER.debug("Tried to play Ribbit sound with byte offset, but no existing sound was found! Playing from the start instead...");
                    }
                    ((IChannelDuck)channel).ribbits$attachStaticBufferWithTickOffset((class_1113)instrumentSoundInstance, (class_4231)soundBuffer, 0);
                }
            } else {
                ((IChannelDuck)channel).ribbits$attachStaticBufferWithTickOffset((class_1113)instrumentSoundInstance, (class_4231)soundBuffer, instrumentSoundInstance.getTicksOffset());
            }
            channel.method_19650();
        }));
        this.field_5557.add((class_1117)instrumentSoundInstance);
    }

    @Override
    @Unique
    public void ribbits$stopRibbitsMusic(UUID ribbitEntityId) {
        List<RibbitInstrumentSoundInstance> soundsToStop = this.field_5557.stream().filter(instance -> instance instanceof RibbitInstrumentSoundInstance).map(instance -> (RibbitInstrumentSoundInstance)((Object)instance)).filter(instance -> instance.getRibbit().method_5667().equals(ribbitEntityId)).toList();
        soundsToStop.forEach(InstrumentSoundInstance::stopSound);
    }

    @Override
    @Unique
    public void ribbits$stopMaraca(UUID playerId) {
        List<PlayerInstrumentSoundInstance> soundsToStop = this.field_5557.stream().filter(instance -> instance instanceof PlayerInstrumentSoundInstance).map(instance -> (PlayerInstrumentSoundInstance)((Object)instance)).filter(instance -> instance.getPlayer().method_5667().equals(playerId)).toList();
        soundsToStop.forEach(InstrumentSoundInstance::stopSound);
    }
}

