/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepdimension.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class Modelwarden
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"deepdimension", (String)"modelwarden"), "main");
    public final ModelPart head;
    public final ModelPart left_tendril;
    public final ModelPart right_tendril;
    public final ModelPart torso;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public Modelwarden(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.left_tendril = root.getChild("left_tendril");
        this.right_tendril = root.getChild("right_tendril");
        this.torso = root.getChild("torso");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(19, 34).addBox(-16.0f, -64.0f, -10.0f, 32.0f, 32.0f, 22.0f, new CubeDeformation(0.0f)).texOffs(109, 9).addBox(-18.0f, -65.0f, -12.0f, 36.0f, 18.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-32.0f, (float)-13.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition left_tendril = partdefinition.addOrReplaceChild("left_tendril", CubeListBuilder.create().texOffs(66, 0).addBox(0.0f, -46.0f, 0.0f, 32.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)16.0f, (float)-56.0f, (float)-11.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition right_tendril = partdefinition.addOrReplaceChild("right_tendril", CubeListBuilder.create().texOffs(0, 0).addBox(-32.0f, -46.0f, 0.0f, 32.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-16.0f, (float)-56.0f, (float)-11.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 90).addBox(-16.0f, -26.0f, -8.0f, 32.0f, 28.0f, 18.0f, new CubeDeformation(0.0f)).texOffs(99, 133).addBox(-22.0f, -58.0f, -11.0f, 44.0f, 32.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-18.0f, (float)11.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(7, 142).addBox(-4.0f, -32.0f, -10.0f, 22.0f, 74.0f, 22.0f, new CubeDeformation(0.0f)).texOffs(96, 190).addBox(-6.0f, 22.0f, -12.0f, 26.0f, 38.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offset((float)26.0f, (float)-36.0f, (float)-5.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 139).addBox(-18.0f, -32.0f, -10.0f, 22.0f, 74.0f, 22.0f, new CubeDeformation(0.0f)).texOffs(101, 61).addBox(-20.0f, 22.0f, -14.0f, 26.0f, 38.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-26.0f, (float)-36.0f, (float)-3.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(236, 0).addBox(-11.8f, -14.0f, -8.0f, 16.0f, 40.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)12.0f, (float)-2.0f, (float)11.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(236, 157).addBox(-4.2f, -14.0f, -8.0f, 16.0f, 40.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-12.0f, (float)-2.0f, (float)11.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)300, (int)300);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

