/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepdimension.init;

import net.mcreator.deepdimension.entity.AncientProtectorEntity;
import net.mcreator.deepdimension.entity.SculkZombieEntity;
import net.mcreator.deepdimension.entity.SilenceKeeperEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class DeepdimensionModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"deepdimension");
    public static final DeferredHolder<EntityType<?>, EntityType<SculkZombieEntity>> SCULK_ZOMBIE = DeepdimensionModEntities.register("sculk_zombie", EntityType.Builder.of(SculkZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AncientProtectorEntity>> ANCIENT_PROTECTOR = DeepdimensionModEntities.register("ancient_protector", EntityType.Builder.of(AncientProtectorEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SilenceKeeperEntity>> SILENCE_KEEPER = DeepdimensionModEntities.register("silence_keeper", EntityType.Builder.of(SilenceKeeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(170).setUpdateInterval(3).fireImmune().sized(4.0f, 6.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SculkZombieEntity.init(event);
        AncientProtectorEntity.init(event);
        SilenceKeeperEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCULK_ZOMBIE.get(), SculkZombieEntity.createAttributes().build());
        event.put((EntityType)ANCIENT_PROTECTOR.get(), AncientProtectorEntity.createAttributes().build());
        event.put((EntityType)SILENCE_KEEPER.get(), SilenceKeeperEntity.createAttributes().build());
    }
}

