/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.client.InfestedBedBakedModel;
import net.mehvahdjukaar.sleep_tight.client.particles.BedbugParticle;
import net.mehvahdjukaar.sleep_tight.client.particles.DreamParticle;
import net.mehvahdjukaar.sleep_tight.client.particles.MimimiParticle;
import net.mehvahdjukaar.sleep_tight.client.renderers.BedbugEntityRenderer;
import net.mehvahdjukaar.sleep_tight.client.renderers.HammockBlockTileRenderer;
import net.mehvahdjukaar.sleep_tight.client.renderers.InfestedBedRenderer;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_6344;
import org.jetbrains.annotations.Nullable;

public class SleepTightClient {
    public static final class_5601 NIGHT_BAG = SleepTightClient.loc("night_bag");
    public static final class_5601 HAMMOCK = SleepTightClient.loc("hammock");
    public static final class_5601 BEDBUG = SleepTightClient.loc("bedbug");
    public static final class_2960 BED_SHEET = new class_2960("textures/atlas/beds.png");
    public static final class_2960 ICONS = SleepTight.res("textures/gui/sleep_icons.png");
    public static final class_2960 BEDBUG_TEXTURE = SleepTight.res("textures/entity/bedbug.png");
    public static final class_2960 SLEEPING_VILLAGER_TEXTURE = SleepTight.res("textures/entity/villager_sleeping.png");
    public static final class_4730[] HAMMOCK_TEXTURES = (class_4730[])Arrays.stream(class_1767.values()).sorted(Comparator.comparingInt(class_1767::method_7789)).map(dyeColor -> new class_4730(BED_SHEET, SleepTight.res("entity/bed/hammock_" + dyeColor.method_7792()))).toArray(class_4730[]::new);
    public static boolean HAS_SNORE = Calendar.getInstance().get(2) == 3 && Calendar.getInstance().get(5) == 1;
    private static long lastTick = 0L;
    private static boolean hasDreamEssenceInRange = false;

    public static void init() {
        ClientHelper.addModelLayerRegistration(SleepTightClient::registerLayers);
        ClientHelper.addEntityRenderersRegistration(SleepTightClient::registerEntityRenderers);
        ClientHelper.addBlockEntityRenderersRegistration(SleepTightClient::registerBlockEntityRenderers);
        ClientHelper.addParticleRegistration(SleepTightClient::registerParticles);
        ClientHelper.addModelLoaderRegistration(SleepTightClient::registerModelLoaders);
    }

    private static class_5601 loc(String name) {
        return new class_5601(SleepTight.res(name), name);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((class_2396)SleepTight.DREAM_PARTICLE.get(), DreamParticle.Factory::new);
        event.register((class_2396)SleepTight.BEDBUG_PARTICLE.get(), BedbugParticle.Factory::new);
        event.register((class_2396)SleepTight.ZZZ_PARTICLE.get(), MimimiParticle.Factory::new);
    }

    private static void registerLayers(ClientHelper.ModelLayerEvent event) {
        event.register(HAMMOCK, HammockBlockTileRenderer::createLayer);
        event.register(BEDBUG, BedbugEntityRenderer::createLayer);
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(SleepTight.BED_ENTITY.get(), class_6344::new);
        event.register(SleepTight.DREAMER_ESSENCE_ENTITY.get(), class_6344::new);
        event.register((class_1299)SleepTight.BEDBUG_ENTITY.get(), BedbugEntityRenderer::new);
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(SleepTight.HAMMOCK_TILE.get(), HammockBlockTileRenderer::new);
        event.register(SleepTight.INFESTED_BED_TILE.get(), InfestedBedRenderer::new);
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(SleepTight.res("infested_bed"), (CustomModelLoader)new InfestedBedBakedModel.Loader());
    }

    public static class_1657 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static void onEntityTick(class_1309 entity) {
        if (entity.method_6113() && ClientConfigs.ZZZ_PARTICLES.get().booleanValue() && !entity.method_5864().method_20210(SleepTight.NO_SLEEP_PARTICLES) && entity.field_6012 % 35 == 0) {
            class_2680 bedState;
            class_243 pos = entity.method_19538().method_1031(0.0, (double)(entity.method_5751() + 0.0625f), 0.0);
            class_1937 level = entity.method_37908();
            float yawDeg = 180.0f - entity.method_5705(1.0f);
            Optional bedPos = entity.method_18398();
            if (bedPos.isPresent() && (bedState = level.method_8320((class_2338)bedPos.get())).method_28498((class_2769)class_2244.field_11177)) {
                yawDeg = -((class_2350)bedState.method_11654((class_2769)class_2244.field_11177)).method_10144();
            }
            level.method_8406((class_2394)SleepTight.ZZZ_PARTICLE.get(), pos.field_1352, pos.field_1351, pos.field_1350, (double)yawDeg, (double)entity.method_5628(), 0.0);
        }
    }

    @Nullable
    public static BedData getLayingBedData() {
        class_1657 player = SleepTightClient.getPlayer();
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof BedEntity) {
            BedEntity be = (BedEntity)vehicle;
            class_2338 pos = be.method_24515();
            return STPlatStuff.getBedData(player.method_37908(), pos);
        }
        return null;
    }

    public static boolean getCachedDreamEssenceInRange(class_2338 pos, class_1937 level) {
        if (level.method_8510() != lastTick) {
            hasDreamEssenceInRange = DreamEssenceBlock.isInRangeInternal(pos, level);
            lastTick = level.method_8510();
        }
        return hasDreamEssenceInRange;
    }
}

