/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.entities;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.entity.IControllableVehicle;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.client.ClientEvents;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundAlightCameraOnLayMessage;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSleepImmediatelyMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.network.ServerBoundCommitSleepMessage;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_265;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class BedEntity
extends class_1297
implements IControllableVehicle,
IExtraClientSpawnData {
    private class_2350 dir = class_2350.field_11043;
    public static final class_2941<OffsetMode> SERIALIZER = class_2941.method_43240(OffsetMode.class);
    private static final class_2940<OffsetMode> DATA_OFFSET = class_2945.method_12791(BedEntity.class, SERIALIZER);
    private class_2680 lastBedState = class_2246.field_10124.method_9564();
    private boolean dismountOnTheSpot = false;

    public BedEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public BedEntity(class_1937 worldIn, class_2338 mainPos, class_2680 bedState, OffsetMode offsetMode) {
        super(SleepTight.BED_ENTITY.get(), worldIn);
        class_2350 bedDir = (class_2350)bedState.method_11654((class_2769)class_2244.field_11177);
        this.dir = bedDir.method_10153();
        this.method_36456(this.dir.method_10144());
        this.lastBedState = bedState;
        this.setOffsetMode(offsetMode);
        class_265 shape = bedState.method_26218((class_1922)worldIn, mainPos);
        double yOffset = shape.method_1105(class_2350.class_2351.field_11052);
        this.method_5814((double)mainPos.method_10263() + 0.5, (double)mainPos.method_10264() + yOffset, (double)mainPos.method_10260() + 0.5);
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_OFFSET, (Object)OffsetMode.NONE);
    }

    public OffsetMode getOffsetMode() {
        return (OffsetMode)((Object)this.field_6011.method_12789(DATA_OFFSET));
    }

    public void setOffsetMode(OffsetMode mode) {
        this.field_6011.method_12778(DATA_OFFSET, (Object)mode);
    }

    public class_2350 getBedDirection() {
        return this.dir;
    }

    public boolean isDoubleBed() {
        return this.getOffsetMode() == OffsetMode.DOUBLE_BED;
    }

    public void clearDoubleBed() {
        if (this.getOffsetMode() == OffsetMode.DOUBLE_BED) {
            this.setOffsetMode(OffsetMode.NONE);
            class_2338 otherPos = this.getDoubleBedPos();
            class_1937 level = this.method_37908();
            class_2680 otherState = level.method_8320(otherPos);
            if (otherState == this.lastBedState) {
                level.method_8501(otherPos, (class_2680)otherState.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void method_5773() {
        class_2338 otherPos;
        super.method_5773();
        class_1937 level = this.method_37908();
        List passengers = this.method_5685();
        for (class_1297 p : passengers) {
            p.method_18380(class_4050.field_18078);
            if (this.field_6012 <= 2 || level.field_9236 || !CommonConfigs.SLEEP_IMMEDIATELY.get().booleanValue() || !(p instanceof class_3222)) continue;
            class_3222 sp = (class_3222)p;
            this.startSleepingOn(sp);
        }
        boolean dead = passengers.isEmpty();
        class_2338 pos = this.method_24515();
        class_2680 newBedState = level.method_8320(pos);
        boolean isBed = this.isValidBed(newBedState);
        if (this.isDoubleBed() && this.field_6012 > 2 && level.method_8320(otherPos = this.getDoubleBedPos()) != newBedState) {
            this.clearDoubleBed();
        }
        if (isBed) {
            this.dir = ((class_2350)newBedState.method_11654((class_2769)class_2244.field_11177)).method_10153();
        }
        if (!dead && !isBed) {
            class_2669 pistonBE;
            class_2669 piston = null;
            boolean didOffsetByPiston = false;
            class_2586 tile = level.method_8321(pos);
            if (tile instanceof class_2669 && this.isValidBed((pistonBE = (class_2669)tile).method_11495())) {
                piston = pistonBE;
            } else {
                for (class_2350 d : class_2350.values()) {
                    class_2669 pistonBE2;
                    class_2338 offPos = pos.method_10093(d);
                    tile = level.method_8321(offPos);
                    if (!(tile instanceof class_2669) || !this.isValidBed((pistonBE2 = (class_2669)tile).method_11495())) continue;
                    piston = pistonBE2;
                    break;
                }
            }
            if (piston != null) {
                class_2350 dir = piston.method_11506();
                this.method_5784(class_1313.field_6310, new class_243((double)dir.method_10148() * 0.33, (double)dir.method_10164() * 0.33, (double)dir.method_10165() * 0.33));
                didOffsetByPiston = true;
                this.clearDoubleBed();
            }
            boolean bl = dead = !didOffsetByPiston;
        }
        if (dead && !level.field_9236) {
            if (isBed) {
                level.method_8501(pos, (class_2680)newBedState.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false)));
            }
            this.clearDoubleBed();
            this.method_31472();
        }
        this.lastBedState = newBedState;
    }

    public static class_243 getDoubleBedOffset(class_2350 dir, class_243 vec3) {
        class_2350 d = dir.method_10160();
        return vec3.method_1031((double)d.method_10148() * -0.5, 0.0, (double)d.method_10165() * -0.5);
    }

    public static class_2338 getDoubleBedPos(class_2338 pos, class_2680 state) {
        return pos.method_10093(((class_2350)state.method_11654((class_2769)class_2244.field_11177)).method_10170());
    }

    public static class_2338 getInverseDoubleBedPos(class_2338 pos, class_2680 state) {
        return pos.method_10093(((class_2350)state.method_11654((class_2769)class_2244.field_11177)).method_10160());
    }

    public class_2338 getDoubleBedPos() {
        return this.method_24515().method_10093(this.dir.method_10160());
    }

    private boolean isValidBed(class_2680 state) {
        class_2248 b = state.method_26204();
        if (b instanceof class_2244) {
            return state.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560;
        }
        if (b instanceof HammockBlock) {
            return ((HammockPart)((Object)state.method_11654(HammockBlock.PART))).isMaster();
        }
        return false;
    }

    public boolean method_5727(double x, double y, double z) {
        return false;
    }

    public boolean method_5640(double distance) {
        return false;
    }

    protected void method_5749(@NotNull class_2487 compound) {
        this.setOffsetMode(OffsetMode.values()[compound.method_10571("mode")]);
    }

    protected void method_5652(@NotNull class_2487 compound) {
        compound.method_10567("mode", (byte)this.getOffsetMode().ordinal());
    }

    public class_2596<class_2602> method_18002() {
        return PlatHelper.getEntitySpawnPacket((class_1297)this);
    }

    public double method_5621() {
        return 0.0125;
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        if (this.method_5626(passenger)) {
            class_2248 class_22482 = this.lastBedState.method_26204();
            if (class_22482 instanceof IModBed) {
                IModBed b = (IModBed)class_22482;
                class_243 v = b.getSleepingPosition(this.lastBedState, this.method_24515());
                callback.accept(passenger, v.field_1352, v.field_1351, v.field_1350);
            } else {
                class_243 c = this.method_19538();
                if (this.isDoubleBed()) {
                    c = BedEntity.getDoubleBedOffset(this.dir.method_10153(), c);
                }
                callback.accept(passenger, c.field_1352, c.field_1351, c.field_1350);
            }
        }
    }

    public void method_5644(class_1297 entity) {
        float diff = class_3532.method_15393((float)(entity.method_5791() - this.method_36454()));
        float clampedDiff = class_3532.method_15363((float)diff, (float)-90.0f, (float)90.0f);
        float subtract = clampedDiff - diff;
        ((class_1309)entity).field_6241 += subtract;
        entity.method_36457(class_3532.method_15363((float)entity.method_36455(), (float)-75.0f, (float)0.0f));
    }

    protected void method_5627(class_1297 passenger) {
        class_1657 player;
        super.method_5627(passenger);
        this.method_24201(passenger);
        passenger.method_36456(this.method_36454());
        passenger.method_22862();
        passenger.method_18380(class_4050.field_18078);
        if (passenger instanceof class_1657 && (player = (class_1657)passenger).method_7340()) {
            ClientEvents.displayRidingMessage(this);
            BedEntity.alignCamera(player, this.method_36454());
        }
    }

    public static void alignCamera(class_1657 player, float bedYRot) {
        player.method_36456(bedYRot);
        player.method_5847(bedYRot);
        player.field_5982 = player.method_36454();
        player.field_6259 = player.field_6241;
    }

    protected void method_5793(class_1297 passenger) {
        class_1657 p;
        super.method_5793(passenger);
        this.method_24201(passenger);
        if (passenger instanceof class_1657 && (p = (class_1657)passenger).method_6113()) {
            passenger.method_18380(class_4050.field_18078);
        } else {
            passenger.method_18380(class_4050.field_18076);
        }
    }

    public void onInputUpdate(boolean left, boolean right, boolean up, boolean down, boolean sprint, boolean jumping) {
        class_2586 class_25862;
        if (jumping) {
            NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCommitSleepMessage());
            if (this.method_37908().field_9236 && SleepTightClient.HAS_SNORE) {
                ((class_1297)this.method_5685().get(0)).method_5783(SleepTight.SNORE_SOUND.get(), 1.0f, class_3532.method_32750((class_5819)this.field_5974, (float)0.9f, (float)1.1f));
            }
        } else if (left ^ right && (class_25862 = this.method_37908().method_8321(this.method_23312())) instanceof HammockTile) {
            HammockTile tile = (HammockTile)class_25862;
            if (left) {
                tile.accelerateLeft();
            } else {
                tile.accelerateRight();
            }
        }
    }

    public void writeSpawnData(class_2540 buf) {
        buf.writeInt(this.dir.method_10161());
        buf.writeInt(this.getOffsetMode().ordinal());
        boolean isValid = !this.method_5685().isEmpty();
        buf.writeBoolean(isValid);
        if (isValid) {
            buf.method_10797(((class_1297)this.method_5685().get(0)).method_5667());
        }
    }

    public void readSpawnData(class_2540 buf) {
        this.dir = class_2350.method_10139((int)buf.readInt());
        this.setOffsetMode(OffsetMode.values()[buf.readInt()]);
        if (buf.readBoolean()) {
            UUID uniqueId = buf.method_10790();
            class_1657 p = this.method_37908().method_18470(uniqueId);
            if (p != null) {
                p.method_5804((class_1297)this);
            }
        }
    }

    public class_5250 getRidingMessage(class_2561 keyMessage, class_2561 shiftMessage) {
        this.lastBedState = this.method_37908().method_8320(this.method_24515());
        if (this.lastBedState.method_26204() instanceof HammockBlock) {
            return class_2561.method_43469((String)"message.sleep_tight.start_resting", (Object[])new Object[]{keyMessage, shiftMessage});
        }
        return class_2561.method_43469((String)"message.sleep_tight.start_sleeping", (Object[])new Object[]{keyMessage, shiftMessage});
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5698(class_1297 entity) {
        return true;
    }

    public boolean method_5655() {
        return true;
    }

    public class_243 method_24829(class_1309 passenger) {
        if (this.dismountOnTheSpot) {
            return super.method_24829(passenger);
        }
        Optional o = class_2244.method_9484((class_1299)passenger.method_5864(), (class_1941)passenger.method_37908(), (class_2338)this.method_24515(), (class_2350)this.dir.method_10153(), (float)passenger.method_36454());
        return o.orElseGet(() -> super.method_24829(passenger));
    }

    private static boolean isHammock3L(class_2680 state) {
        return state.method_26204() instanceof HammockBlock && !((HammockPart)((Object)state.method_11654(HammockBlock.PART))).isOnFence();
    }

    public void startSleepingOn(class_3222 player) {
        class_2338 pos = this.method_24515();
        if (!this.isValidBed(this.method_37908().method_8320(pos))) {
            return;
        }
        this.dismountOnTheSpot = true;
        Either r = player.method_7269(pos);
        this.dismountOnTheSpot = false;
        Optional op = r.left();
        if (op.isPresent()) {
            class_2561 m;
            class_2248 class_22482;
            player.method_5873((class_1297)this, true);
            class_1657.class_1658 problem = (class_1657.class_1658)op.get();
            if (problem == class_1657.class_1658.field_7529 && (class_22482 = this.lastBedState.method_26204()) instanceof IModBed) {
                IModBed mb = (IModBed)class_22482;
                m = mb.getSleepingProblemMessage();
            } else {
                m = problem.method_19206();
            }
            if (m != null) {
                player.method_7353(m, true);
            }
        } else {
            player.method_29239();
            PlayerSleepData data = STPlatStuff.getPlayerSleepData((class_1657)player);
            data.setDoubleBed(this.isDoubleBed());
            data.syncToClient(player);
            NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSleepImmediatelyMessage(pos));
            class_1937 level = this.method_37908();
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_26204() instanceof class_2244) {
                level.method_8501(pos, (class_2680)blockState.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(true)));
            }
            this.method_31472();
        }
    }

    public static void layDown(class_2680 state, class_2338 pos, class_1657 player) {
        class_1937 level = player.method_37908();
        if (!level.field_9236) {
            OffsetMode mode = OffsetMode.NONE;
            if (BedEntity.isHammock3L(state)) {
                mode = OffsetMode.HAMMOCK_3L;
            }
            if (CommonConfigs.DOUBLE_BED.get().booleanValue() && state.method_26164(class_3481.field_16443)) {
                class_2350 dir = ((class_2350)state.method_11654((class_2769)class_2244.field_11177)).method_10170();
                class_2338 relative = pos.method_10093(dir);
                class_2680 s = level.method_8320(relative);
                if (s == state) {
                    level.method_8501(relative, (class_2680)state.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(true)));
                    mode = OffsetMode.DOUBLE_BED;
                } else {
                    relative = pos.method_10093(dir = dir.method_10153());
                    s = level.method_8320(relative);
                    if (s == state) {
                        level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(true)));
                        mode = OffsetMode.DOUBLE_BED;
                        pos = relative;
                    }
                }
            }
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(true)));
            BedEntity bedEntity = new BedEntity(level, pos, state, mode);
            player.method_5804((class_1297)bedEntity);
            level.method_8649((class_1297)bedEntity);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                NetworkHandler.CHANNEL.sendToClientPlayer(serverPlayer, (Message)new ClientBoundAlightCameraOnLayMessage(bedEntity));
            }
        } else {
            class_2586 mode = level.method_8321(pos);
            if (mode instanceof HammockTile) {
                HammockTile tile = (HammockTile)mode;
                class_243 d = player.method_18798();
                double vel = d.method_1026(MthUtils.V3itoV3((class_2382)tile.getDirection().method_10170().method_10163())) / d.method_1033();
                tile.addImpulse((float)(-vel * (double)1.1f));
            }
        }
    }

    public static enum OffsetMode {
        NONE,
        HAMMOCK_3L,
        DOUBLE_BED;

    }
}

