/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.tiles;

import net.mehvahdjukaar.moonlight.api.client.anim.PendulumAnimation;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.network.AccelerateHammockMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.network.ServerBoundFallFromHammockMessage;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public class HammockTile
extends class_2586 {
    private final class_1767 color;
    private boolean accelerateLeft;
    private boolean accelerateRight;
    private float pivotOffset;
    private class_2350 direction;
    private final PendulumAnimation animation;

    public HammockTile(class_2338 blockPos, class_2680 blockState) {
        super(SleepTight.HAMMOCK_TILE.get(), blockPos, blockState);
        this.color = ((HammockBlock)blockState.method_26204()).getColor();
        this.pivotOffset = ((HammockPart)((Object)blockState.method_11654(HammockBlock.PART))).getPivotOffset();
        this.direction = (class_2350)blockState.method_11654((class_2769)HammockBlock.field_11177);
        this.animation = PlatHelper.getPhysicalSide().isClient() ? new PendulumAnimation(ClientConfigs.HAMMOCK_ANIMATION_PARAM, this::getRotationAxis) : null;
    }

    private Vector3f getRotationAxis() {
        return ((class_2350)this.method_11010().method_11654((class_2769)HammockBlock.field_11177)).method_23955();
    }

    public class_1767 getColor() {
        return this.color;
    }

    public float getRoll(float partialTicks) {
        if (!ClientConfigs.HAMMOCK_ANIMATION.get().booleanValue()) {
            return 0.0f;
        }
        return this.animation.getAngle(partialTicks);
    }

    public float getPivotOffset() {
        return this.pivotOffset;
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, HammockTile e) {
        if (e.accelerateLeft || e.accelerateRight) {
            double push = ClientConfigs.SWING_FORCE.get();
            e.animation.addImpulse((float)(push * (double)(e.accelerateLeft ? -1 : 1)));
            NetworkHandler.CHANNEL.sendToServer((Message)new AccelerateHammockMessage(pos, e.accelerateLeft));
        }
        e.animation.tick(false);
        if (class_3532.method_15379((float)e.animation.getAngle(0.0f)) > 86.0f && ClientConfigs.HAMMOCK_FALL.get().booleanValue()) {
            for (BedEntity b : e.field_11863.method_18467(BedEntity.class, new class_238(pos))) {
                for (class_1297 p : b.method_5685()) {
                    class_1657 pp;
                    if (p instanceof class_1657 && (pp = (class_1657)p).method_7340()) {
                        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundFallFromHammockMessage());
                        continue;
                    }
                    return;
                }
            }
        }
        e.pivotOffset = ((HammockPart)((Object)state.method_11654(HammockBlock.PART))).getPivotOffset();
        e.direction = (class_2350)state.method_11654((class_2769)HammockBlock.field_11177);
        e.accelerateLeft = false;
        e.accelerateRight = false;
    }

    public void accelerateLeft() {
        this.accelerateLeft = true;
    }

    public void accelerateRight() {
        this.accelerateRight = true;
    }

    public void addImpulse(float vel) {
        this.animation.addImpulse(vel);
    }
}

