/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.client.ClientEvents;
import net.mehvahdjukaar.sleep_tight.common.InvigoratedEffect;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.InfestedBedBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.NightBagBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.BedbugEggsItem;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundNightmarePacket;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.core.SleepEffectsHelper;
import net.mehvahdjukaar.sleep_tight.core.WakeReason;
import net.mehvahdjukaar.sleep_tight.core.WakeUpEncounterHelper;
import net.mehvahdjukaar.sleep_tight.integration.HandcraftedCompat;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1686;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1803;
import net.minecraft.class_1828;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2587;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ModEvents {
    public static long getWakeUpTimeWhenSlept(class_3218 level, long newTimeDayTime) {
        WakeReason wakeReason = WakeReason.SLEPT_SUCCESSFULLY;
        List<class_3222> sleepingPlayers = level.method_18456().stream().filter(class_1657::method_7276).toList();
        ISleepTightBed firstValid = (ISleepTightBed)class_2246.field_10069;
        for (class_1657 class_16572 : sleepingPlayers) {
            ISleepTightBed st;
            class_2248 class_22482 = level.method_8320((class_2338)class_16572.method_18398().get()).method_26204();
            if (!(class_22482 instanceof ISleepTightBed)) continue;
            firstValid = st = (ISleepTightBed)class_22482;
            break;
        }
        HashSet<class_3222> encounterSpawnedFor = new HashSet<class_3222>();
        for (class_3222 player : sleepingPlayers) {
            if (!player.field_13974.method_14267() || !WakeUpEncounterHelper.tryPerformEncounter(player, level, (class_2338)player.method_18398().get())) continue;
            wakeReason = WakeReason.ENCOUNTER;
            encounterSpawnedFor.add(player);
        }
        if (wakeReason == WakeReason.SLEPT_SUCCESSFULLY) {
            double nightmareChance;
            double d = 0.0;
            int players = 0;
            for (class_3222 player : sleepingPlayers) {
                ++players;
                PlayerSleepData c = STPlatStuff.getPlayerSleepData((class_1657)player);
                d += c.getNightmareChance((class_1657)player, (class_2338)player.method_18398().get());
            }
            double d2 = nightmareChance = players == 0 ? 0.0 : d / (double)players;
            if ((double)level.field_9229.method_43057() < nightmareChance) {
                wakeReason = WakeReason.NIGHTMARE;
            }
        }
        long l = level.method_8532();
        long newWakeTime = firstValid.st_modifyWakeUpTime(wakeReason, newTimeDayTime, l);
        long dayTimeDelta = (newWakeTime + 24000L - l) % 24000L;
        for (class_3222 player : sleepingPlayers) {
            switch (wakeReason) {
                case SLEPT_SUCCESSFULLY: {
                    ModEvents.onPlayerSleepFinished(player, dayTimeDelta, newWakeTime);
                    break;
                }
                case ENCOUNTER: {
                    ModEvents.onEncounter(player, encounterSpawnedFor.contains(player), newWakeTime);
                    break;
                }
                case NIGHTMARE: {
                    ModEvents.onNightmare(player, newWakeTime);
                }
            }
        }
        return newWakeTime;
    }

    public static boolean canSetSpawn(class_1657 player, @Nullable class_2338 pos) {
        if (pos != null) {
            class_1937 level = player.method_37908();
            class_2248 block = level.method_8320(pos).method_26204();
            if (block instanceof class_2244) {
                PlayerSleepData pd;
                if (CommonConfigs.ONLY_RESPAWN_IN_HOME_BED.get().booleanValue() && (pd = STPlatStuff.getPlayerSleepData(player)).isBedLastSleptInto(STPlatStuff.getBedData(level, pos))) {
                    return false;
                }
                if (!class_2244.method_27352((class_1937)level) && !CommonConfigs.EXPLOSION_BEHAVIOR.get().canRespawn()) {
                    return false;
                }
            }
            if (block instanceof NightBagBlock) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static class_1269 onRightClickBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_1269 ret;
        if (player.method_7325()) {
            return null;
        }
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        class_2248 b = state.method_26204();
        if (b instanceof InfestedBedBlock) {
            return state.method_26174(level, player, hand, hitResult);
        }
        BedData data = STPlatStuff.getBedData(level, pos);
        if (data == null) {
            return null;
        }
        if (data.isInfested()) {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7909() instanceof class_1803 || stack.method_7909() instanceof class_1828) {
                return class_1269.field_5811;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.bedbug"), true);
            return class_1269.method_29236((boolean)level.field_9236);
        }
        class_2350 dir = (class_2350)state.method_11654((class_2769)class_2244.field_11177);
        if (SleepTight.HANDCRAFTED && (ret = HandcraftedCompat.placeSheet(state, pos, player, hand, hitResult)) != class_1269.field_5811) {
            return ret;
        }
        if (!(state = level.method_8320(pos = ModEvents.getBedHead(state, pos))).method_27852(b)) {
            return class_1269.field_5811;
        }
        class_1799 itemInHand = player.method_5998(hand);
        class_1792 class_17922 = itemInHand.method_7909();
        if (class_17922 instanceof BedbugEggsItem) {
            BedbugEggsItem bb = (BedbugEggsItem)class_17922;
            return bb.useOnBed(player, hand, itemInHand, state, pos, hitResult);
        }
        if (class_2244.method_27352((class_1937)level) && !player.method_21823() && !ModEvents.bedBlocked(level, pos, dir)) {
            boolean occupied = (Boolean)state.method_11654((class_2769)class_2244.field_9968);
            if (occupied) {
                List list = level.method_18467(BedEntity.class, new class_238(pos));
                if (!list.isEmpty()) {
                    BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                    if (!bedEntity.isDoubleBed()) {
                        return class_1269.field_5811;
                    }
                    bedEntity.clearDoubleBed();
                    pos = bedEntity.getDoubleBedPos();
                    state = (class_2680)state.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false));
                    level.method_8501(pos, state);
                    occupied = false;
                } else {
                    class_2338 doublePos = BedEntity.getInverseDoubleBedPos(pos, state);
                    list = level.method_18467(BedEntity.class, new class_238(doublePos));
                    if (!list.isEmpty()) {
                        BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                        if (!bedEntity.isDoubleBed()) {
                            return class_1269.field_5811;
                        }
                        bedEntity.clearDoubleBed();
                        state = (class_2680)state.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false));
                        level.method_8501(pos, state);
                        occupied = false;
                    }
                }
            }
            if (!occupied) {
                boolean extraConditions;
                boolean bl = extraConditions = CommonConfigs.LAY_WHEN_ON_COOLDOWN.get() != false || ModEvents.checkExtraSleepConditions(player, pos);
                if (!extraConditions) {
                    return class_1269.method_29236((boolean)level.field_9236);
                }
                BedEntity.layDown(state, pos, player);
                return class_1269.field_5812;
            }
        }
        return null;
    }

    private static boolean bedBlocked(class_1937 level, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10084();
        return !ModEvents.freeAt(level, blockPos) || !ModEvents.freeAt(level, blockPos.method_10093(direction.method_10153()));
    }

    protected static boolean freeAt(class_1937 level, class_2338 pos) {
        return !level.method_8320(pos).method_26228((class_1922)level, pos);
    }

    public static class_243 getSleepingPosition(class_1297 entity, class_2680 state, class_2338 pos) {
        class_2248 class_22482;
        if (entity.method_37908().field_9236) {
            ClientEvents.onSleepStarted(entity, state, pos);
        }
        if ((class_22482 = state.method_26204()) instanceof IModBed) {
            IModBed iModBed = (IModBed)class_22482;
            return iModBed.getSleepingPosition(state, pos);
        }
        if (state.method_26164(class_3481.field_16443)) {
            class_1657 player;
            PlayerSleepData data;
            class_243 c = class_243.field_1353;
            if (CommonConfigs.FIX_BED_POSITION.get().booleanValue()) {
                c = c.method_1031((double)pos.method_10263() + 0.5, (double)((float)pos.method_10264() + 0.5625f), (double)pos.method_10260() + 0.5);
            }
            if (entity instanceof class_1657 && (data = STPlatStuff.getPlayerSleepData(player = (class_1657)entity)).usingDoubleBed()) {
                c = BedEntity.getDoubleBedOffset((class_2350)state.method_11654((class_2769)class_2244.field_11177), c);
            }
            if (c != class_243.field_1353) {
                return c;
            }
        }
        return null;
    }

    private static void onEncounter(class_3222 player, boolean mobSpawned, long wakeTime) {
        if (mobSpawned) {
            PlayerSleepData c = STPlatStuff.getPlayerSleepData((class_1657)player);
            c.setInsomniaCooldown(wakeTime, CommonConfigs.ENCOUNTER_INSOMNIA_DURATION.get().intValue());
            c.setLasWokenUpTime(wakeTime);
            c.resetConsecutiveNightSleptCounter();
            c.syncToClient(player);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.encounter"), true);
        }
    }

    private static void onNightmare(class_3222 player, long wakeTime) {
        PlayerSleepData c = STPlatStuff.getPlayerSleepData((class_1657)player);
        c.setInsomniaCooldown(wakeTime, CommonConfigs.NIGHTMARE_INSOMNIA_DURATION.get().intValue());
        c.setLasWokenUpTime(wakeTime);
        c.resetConsecutiveNightSleptCounter();
        c.syncToClient(player);
        player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.nightmare"), true);
        player.method_6092(new class_1293(class_1294.field_38092, 60, 0, false, false, false, null, Optional.of(new class_1293.class_7247(20, 10.0f, 1.0f, 1.0f, 60, 1.0f, true))));
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundNightmarePacket());
    }

    public static void onPlayerSleepFinished(class_3222 player, long dayTimeDelta, long wakeUpTime) {
        Optional p = player.method_18398();
        if (p.isPresent()) {
            BedData data;
            class_2338 pos = (class_2338)p.get();
            PlayerSleepData playerCap = STPlatStuff.getPlayerSleepData((class_1657)player);
            class_1937 level = player.method_37908();
            class_2680 state = level.method_8320(pos);
            ISleepTightBed bed = (ISleepTightBed)class_2246.field_10069;
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof ISleepTightBed) {
                ISleepTightBed b;
                bed = b = (ISleepTightBed)class_22482;
            }
            if ((data = STPlatStuff.getBedData(level, pos)) != null) {
                playerCap.increaseNightSleptInThisBed(data, (class_1657)player);
            }
            playerCap.increaseConsecutiveNightSleptCounter(wakeUpTime);
            playerCap.setLasWokenUpTime(wakeUpTime);
            if (bed.st_canSpawnBedbugs()) {
                WakeUpEncounterHelper.trySpawningBedbug(pos, player, data);
            }
            SleepEffectsHelper.applyEffectsOnWakeUp(playerCap, player, dayTimeDelta, pos, bed, state, data);
            playerCap.setInsomniaCooldown(wakeUpTime, bed.st_getCooldown());
            playerCap.syncToClient(player);
        }
    }

    public static void onWokenUp(class_1657 player, boolean hasWokenUpImmediately) {
        Optional p = player.method_18398();
        if (p.isPresent()) {
            class_2338 pos = (class_2338)p.get();
            class_1937 level = player.method_37908();
            class_2680 state = level.method_8320(pos);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof IModBed) {
                IModBed bed = (IModBed)class_22482;
                bed.onLeftBed(state, pos, player);
            } else if (state.method_26164(class_3481.field_16443) && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                PlayerSleepData data = STPlatStuff.getPlayerSleepData(player);
                if (data.usingDoubleBed()) {
                    class_2338 doublePos = BedEntity.getDoubleBedPos(pos, state);
                    class_2680 doubleState = level.method_8320(doublePos);
                    if (doubleState.method_26164(class_3481.field_16443) && (doubleState = (class_2680)doubleState.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false))) == state) {
                        level.method_8501(doublePos, doubleState);
                    }
                    data.setDoubleBed(false);
                    data.syncToClient(serverPlayer);
                }
            }
        }
    }

    public static boolean shouldCancelSetSpawn(class_1657 entity, class_2338 newSpawn) {
        class_2248 class_22482 = entity.method_37908().method_8320(newSpawn).method_26204();
        if (class_22482 instanceof IModBed) {
            IModBed bed = (IModBed)class_22482;
            return !bed.canSetSpawn();
        }
        return false;
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncPlayerSleepCapMessage((class_1657)player));
    }

    public static boolean checkExtraSleepConditions(class_1657 player, @Nullable class_2338 bedPos) {
        class_1937 level = player.method_37908();
        BedData bedData = STPlatStuff.getBedData(level, bedPos);
        if (bedData != null && bedData.isInfested()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.bedbug"), true);
            return false;
        }
        if (STPlatStuff.getPlayerSleepData(player).isOnSleepCooldown(player)) {
            if (!player.method_37908().field_9236) {
                String s = ModEvents.isDayTime(player.method_37908()) ? "message.sleep_tight.insomnia.day" : "message.sleep_tight.insomnia.night";
                player.method_7353((class_2561)class_2561.method_43471((String)s), true);
            }
            return false;
        }
        return SleepEffectsHelper.checkExtraRequirements(player, bedPos);
    }

    public static class_1269 onCheckSleepTime(class_1937 level, class_2338 pos) {
        class_2248 class_22482 = level.method_8320(pos).method_26204();
        if (class_22482 instanceof IModBed) {
            IModBed bed = (IModBed)class_22482;
            return bed.canSleepAtTime(level);
        }
        return class_1269.field_5811;
    }

    public static void onEntityKilled(class_1309 entity, class_1297 killer) {
        class_1937 class_19372;
        if (!entity.method_31481() && (class_19372 = entity.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (killer instanceof class_1309) {
                class_1309 le = (class_1309)killer;
                if (killer.method_5874(serverLevel, entity)) {
                    InvigoratedEffect.onLivingDeath(serverLevel, entity, le);
                }
            }
        }
    }

    public static boolean isDayTime(class_1937 level) {
        int dayDuration = 24000;
        long dayTime = level.method_8532() % (long)dayDuration;
        return dayTime > 100L && dayTime < (long)(dayDuration / 2 - 100);
    }

    public static void onPlayerRespawned(class_3222 newPlayer) {
        class_2338 pos;
        if (CommonConfigs.RESPAWN_LAYING.get().booleanValue() && (pos = newPlayer.method_26280()) != null) {
            class_2680 state = newPlayer.method_37908().method_8320(pos);
            BedData bedData = STPlatStuff.getBedData(newPlayer.method_37908(), pos);
            if (bedData != null) {
                BedEntity.layDown(state, pos, (class_1657)newPlayer);
            }
        }
    }

    @Nullable
    public static Optional<class_243> findSpawnPosition(class_3222 player, class_2338 spawnBlockPos, boolean isRespawnForced) {
        BedData bedData;
        if (!isRespawnForced && CommonConfigs.ONLY_RESPAWN_IN_HOME_BED.get().booleanValue() && (bedData = STPlatStuff.getBedData(player.method_37908(), spawnBlockPos)) != null && !STPlatStuff.getPlayerSleepData((class_1657)player).isBedLastSleptInto(bedData)) {
            return Optional.empty();
        }
        return null;
    }

    public static void onProjectileHitBed(class_1676 projectile, class_1937 level, class_2680 state, class_3965 hit) {
        if (projectile instanceof class_1686) {
            class_1842 p;
            class_1686 tp = (class_1686)projectile;
            class_2338 myPos = hit.method_17777();
            class_2338 pos = ModEvents.getBedHead(state, myPos);
            BedData data = STPlatStuff.getBedData(level, pos);
            if (data != null && data.isInfested() && (p = class_1844.method_8063((class_1799)tp.method_7495())).method_8049().stream().anyMatch(e -> e.method_5579() == class_1294.field_5921)) {
                level.method_8396(null, pos, class_3417.field_14673, class_3419.field_15245, 1.0f, 1.3f);
                if (!level.field_9236) {
                    NetworkHandler.CHANNEL.sendToAllClientPlayersInRange(level, pos, 32.0, (Message)ClientBoundParticleMessage.bedbugInfest(pos, ((class_2350)state.method_11654((class_2769)class_2244.field_11177)).method_10153()));
                }
                data.setBedBug(null);
                class_2586 tile = level.method_8321(pos);
                if (tile != null) {
                    level.method_8413(pos, state, state, 3);
                    tile.method_5431();
                }
            }
        }
    }

    public static void spawnAfterBreakBed(class_2680 state, class_3218 level, class_2338 pos, @Nullable class_2586 be) {
        if (level.field_9236) {
            return;
        }
        BedData data = STPlatStuff.getBedData((class_1937)level, pos, be);
        if (data != null && data.isInfested() && level.method_8450().method_8355(class_1928.field_19392)) {
            class_2487 tag = data.getBedBug();
            Optional opt = class_1299.method_5892((class_2487)tag, (class_1937)level);
            if (opt.isEmpty()) {
                return;
            }
            class_1297 entity = (class_1297)opt.get();
            pos = ModEvents.bedBedFeet(state, pos);
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
            level.method_8649(entity);
            if (entity instanceof class_1308) {
                class_1308 le = (class_1308)entity;
                le.method_5990();
            }
        }
    }

    public static void animateTickBed(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        BedData data;
        if ((double)random.method_43057() < 0.3 && (data = STPlatStuff.getBedData(level, pos)) != null && data.isInfested()) {
            float x = (float)pos.method_10263() + level.field_9229.method_43057();
            float z = (float)pos.method_10260() + level.field_9229.method_43057();
            double y = state.method_26220((class_1922)level, pos).method_1105(class_2350.class_2351.field_11052) + (double)pos.method_10264();
            level.method_8406((class_2394)SleepTight.BEDBUG_PARTICLE.get(), (double)x, y + 0.01, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public static class_2338 getBedHead(class_2680 bed, class_2338 pos) {
        if (!bed.method_28498((class_2769)class_2244.field_9967)) {
            return pos;
        }
        class_2742 part = (class_2742)bed.method_11654((class_2769)class_2244.field_9967);
        if (part == class_2742.field_12560) {
            return pos;
        }
        class_2350 dir = (class_2350)bed.method_11654((class_2769)class_2244.field_11177);
        return pos.method_10093(dir);
    }

    public static class_2338 bedBedFeet(class_2680 bed, class_2338 pos) {
        if (!bed.method_28498((class_2769)class_2244.field_9967)) {
            return pos;
        }
        class_2742 part = (class_2742)bed.method_11654((class_2769)class_2244.field_9967);
        if (part == class_2742.field_12557) {
            return pos;
        }
        class_2350 dir = (class_2350)bed.method_11654((class_2769)class_2244.field_11177);
        return pos.method_10093(dir.method_10153());
    }

    public static boolean shouldHaveBedData(class_2586 blockEntity) {
        class_2587 be;
        class_2680 state = blockEntity.method_11010();
        if (state.method_26164(SleepTight.LAYING_BED_BLACKLIST)) {
            return false;
        }
        return state.method_26204() instanceof class_2244 && state.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560 || blockEntity instanceof class_2587 && (be = (class_2587)blockEntity).method_11010().method_28498((class_2769)class_2244.field_9967) && be.method_11010().method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560;
    }
}

