/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4158;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerSleepData {
    protected static final String HOME_BED_NBT = "home_bed_id";
    protected static final String INSOMNIA_ELAPSE_NBT = "insomnia_elapses_at";
    protected static final String LAST_TIME_SLEPT_NBT = "last_time_slept";
    protected static final String CONSECUTIVE_NIGHTS_NBT = "consecutive_nights";
    protected static final String HOME_BED_LEVEL_NBT = "home_bed_nights";
    protected static final String USING_DOUBLE_BED_NBT = "using_double_bed";
    protected static final String LAST_KNOWN_TIME_NBT = "last_known_time";
    @Nullable
    private UUID homeBed = null;
    private long insomniaWillElapseTimeStamp = 0L;
    private long lastWokenUpTimeStamp = -1L;
    private long lastKnownTimeStamp = 0L;
    private int consecutiveNightsSlept = 0;
    private int nightsSleptInSameBed = 0;
    private boolean usingDoubleBed = false;

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.homeBed != null) {
            tag.method_25927(HOME_BED_NBT, this.homeBed);
        }
        tag.method_10544(INSOMNIA_ELAPSE_NBT, this.insomniaWillElapseTimeStamp);
        tag.method_10544(LAST_TIME_SLEPT_NBT, this.lastWokenUpTimeStamp);
        tag.method_10569(CONSECUTIVE_NIGHTS_NBT, this.consecutiveNightsSlept);
        tag.method_10569(HOME_BED_LEVEL_NBT, this.nightsSleptInSameBed);
        tag.method_10556(USING_DOUBLE_BED_NBT, this.usingDoubleBed);
        tag.method_10544(LAST_KNOWN_TIME_NBT, this.lastKnownTimeStamp);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        if (tag.method_10545(HOME_BED_NBT)) {
            this.homeBed = tag.method_25926(HOME_BED_NBT);
        }
        this.insomniaWillElapseTimeStamp = tag.method_10537(INSOMNIA_ELAPSE_NBT);
        this.lastWokenUpTimeStamp = tag.method_10537(LAST_TIME_SLEPT_NBT);
        this.consecutiveNightsSlept = tag.method_10550(CONSECUTIVE_NIGHTS_NBT);
        this.nightsSleptInSameBed = tag.method_10550(HOME_BED_LEVEL_NBT);
        this.usingDoubleBed = tag.method_10577(USING_DOUBLE_BED_NBT);
        this.lastKnownTimeStamp = tag.method_10537(LAST_KNOWN_TIME_NBT);
    }

    public void tick(class_3222 player) {
        long gameTime = player.method_37908().method_8532();
        if (gameTime < this.lastKnownTimeStamp) {
            if (this.isOnSleepCooldown((class_1657)player)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.time_skipped"), false);
            }
            this.insomniaWillElapseTimeStamp = 0L;
            this.lastWokenUpTimeStamp = -1L;
            this.lastKnownTimeStamp = gameTime;
            this.syncToClient(player);
        }
    }

    public void setInsomniaCooldown(long dayTimeNow, long cooldownDuration) {
        this.insomniaWillElapseTimeStamp = dayTimeNow + cooldownDuration;
        this.lastKnownTimeStamp = dayTimeNow;
    }

    public void setLasWokenUpTime(long dayTimeNow) {
        this.lastWokenUpTimeStamp = dayTimeNow;
        this.lastKnownTimeStamp = dayTimeNow;
    }

    public void increaseNightSleptInThisBed(BedData bed, class_1657 player) {
        if (this.isBedLastSleptInto(bed)) {
            ++this.nightsSleptInSameBed;
            if (this.isBedFamiliar()) {
                bed.incrementBedLevel(player);
            }
        } else {
            if (this.nightsSleptInSameBed != 0) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.home_bed_lost"), false);
            }
            this.setLastSleptInto(bed);
            this.nightsSleptInSameBed = 0;
        }
    }

    public void increaseConsecutiveNightSleptCounter(long wakeUpTime) {
        long awakeTime = wakeUpTime - this.lastWokenUpTimeStamp;
        this.consecutiveNightsSlept = awakeTime > (long)CommonConfigs.SLEEP_INTERVAL.get().intValue() ? 0 : ++this.consecutiveNightsSlept;
    }

    public void resetConsecutiveNightSleptCounter() {
        this.consecutiveNightsSlept = 0;
    }

    public long getInsomniaCooldown(class_1657 player) {
        if (player.method_31549().field_7477) {
            return 0L;
        }
        return this.insomniaWillElapseTimeStamp - player.method_37908().method_8532();
    }

    public float getInsomniaCooldownPercentage(class_1657 player) {
        long timeLeft = this.getInsomniaCooldown(player);
        if (timeLeft < 0L) {
            return 0.0f;
        }
        long maxCooldown = this.insomniaWillElapseTimeStamp - this.lastWokenUpTimeStamp;
        return (float)timeLeft / (float)maxCooldown;
    }

    public boolean isOnSleepCooldown(class_1657 player) {
        if (player.method_31549().field_7477) {
            return false;
        }
        return this.getInsomniaCooldown(player) > 0L;
    }

    public double getNightmareChance(class_1657 player, class_2338 pos) {
        ISleepTightBed bed;
        if (player.method_31549().field_7477) {
            return 0.0;
        }
        int minNights = CommonConfigs.NIGHTMARES_CONSECUTIVE_NIGHTS.get();
        if (this.consecutiveNightsSlept < minNights) {
            return 0.0;
        }
        if (DreamEssenceBlock.isInRange(player.method_24515(), player.method_37908())) {
            return 0.0;
        }
        class_2680 state = player.method_37908().method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ISleepTightBed && !(bed = (ISleepTightBed)class_22482).st_canCauseNightmares()) {
            return 0.0;
        }
        double chance = CommonConfigs.NIGHTMARE_CHANCE_INCREMENT_PER_NIGHT.get() * (double)(this.consecutiveNightsSlept - minNights - 1);
        if (!((class_4158)class_7923.field_41128.method_29107(class_7477.field_39291)).method_35159(state)) {
            chance *= CommonConfigs.SPECIAL_BED_NIGHTMARE_CHANCE_MULT.get().doubleValue();
        }
        return chance;
    }

    @Nullable
    public UUID getLastBedSleptInto() {
        return this.homeBed;
    }

    public int getConsecutiveNightsSlept() {
        return this.consecutiveNightsSlept;
    }

    public float getBedFamiliarity() {
        return Math.min(1.0f, (float)this.nightsSleptInSameBed / (float)CommonConfigs.HOME_BED_REWARD_REQUIRED_NIGHTS.get().intValue());
    }

    public boolean isBedFamiliar() {
        return this.getBedFamiliarity() >= 1.0f;
    }

    public int getNightsSleptInHomeBed() {
        return this.nightsSleptInSameBed;
    }

    public long getLastWokenUpTime() {
        return this.lastWokenUpTimeStamp;
    }

    public long getInsomniaWillElapseTime() {
        return this.insomniaWillElapseTimeStamp;
    }

    public void acceptFromServer(UUID id, long insominaElapse, long sleepTimestamp, int nightSlept, int homeBedNights, boolean doubleBed) {
        this.homeBed = id;
        this.insomniaWillElapseTimeStamp = insominaElapse;
        this.consecutiveNightsSlept = nightSlept;
        this.lastWokenUpTimeStamp = sleepTimestamp;
        this.nightsSleptInSameBed = homeBedNights;
        this.usingDoubleBed = doubleBed;
    }

    public void syncToClient(class_3222 player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncPlayerSleepCapMessage(this));
    }

    public void setConsecutiveNightsSlept(int consecutiveNightsSlept) {
        this.consecutiveNightsSlept = consecutiveNightsSlept;
    }

    public void setNightsSleptInHomeBed(int nightsSleptInHomeBed) {
        this.nightsSleptInSameBed = nightsSleptInHomeBed;
    }

    public void copyFrom(PlayerSleepData oldData) {
        this.consecutiveNightsSlept = oldData.consecutiveNightsSlept;
        this.homeBed = oldData.homeBed;
        this.nightsSleptInSameBed = oldData.nightsSleptInSameBed;
        this.insomniaWillElapseTimeStamp = oldData.insomniaWillElapseTimeStamp;
        this.lastWokenUpTimeStamp = oldData.lastWokenUpTimeStamp;
        this.usingDoubleBed = oldData.usingDoubleBed;
    }

    public boolean usingDoubleBed() {
        return this.usingDoubleBed;
    }

    public void setDoubleBed(boolean doubleBed) {
        this.usingDoubleBed = doubleBed;
    }

    public boolean isBedLastSleptInto(@Nullable BedData bedData) {
        return bedData != null && bedData.getId().equals(this.getLastBedSleptInto());
    }

    public void setLastSleptInto(BedData data) {
        this.homeBed = data.getId();
    }
}

