/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.augment.AugmentBase;
import com.rekindled.embers.augment.BlastingExplosion;
import com.rekindled.embers.augment.ToolExplosion;
import com.rekindled.embers.util.EmberInventoryUtil;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlastingCoreAugment
extends AugmentBase {
    public static HashSet<Entity> blastedEntities = new HashSet();

    public BlastingCoreAugment(ResourceLocation id) {
        super(id, 2.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private double getChanceBonus(double resonance) {
        if (resonance > 1.0) {
            return 1.0 + (resonance - 1.0) * 0.5;
        }
        return resonance;
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        ItemStack s;
        int blastingLevel;
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        if (event.getPlayer() != null && !event.getPlayer().m_21205_().m_41619_() && (blastingLevel = AugmentUtil.getAugmentLevel(s = event.getPlayer().m_21205_(), this)) > 0 && EmberInventoryUtil.getEmberTotal(event.getPlayer()) >= this.cost) {
            double resonance = EmbersAPI.getEmberResonance(s);
            double chance = (double)blastingLevel / (double)(blastingLevel + 1) * this.getChanceBonus(resonance);
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            ToolExplosion explosion = new ToolExplosion(s, event.getPlayer().m_9236_(), (Entity)event.getPlayer(), x, y, z, 0.5f, false, Explosion.BlockInteraction.DESTROY, this.getBlastCube(world, pos, event.getPlayer(), chance));
            BlastingCoreAugment.spawnExplosion(event.getPlayer().m_9236_(), explosion, x, y, z, 0.5f);
            EmberInventoryUtil.removeEmber(event.getPlayer(), this.cost);
        }
    }

    public Iterable<BlockPos> getBlastAdjacent(LevelAccessor world, BlockPos pos, Player player, double chance) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (Direction face : Direction.values()) {
            if (!(Misc.random.nextDouble() < chance)) continue;
            posList.add(pos.m_121945_(face));
        }
        return posList;
    }

    public List<BlockPos> getBlastCube(LevelAccessor world, BlockPos pos, Player player, double chance) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (Direction facePrimary : Direction.values()) {
            if (!(Misc.random.nextDouble() < chance)) continue;
            BlockPos posPrimary = pos.m_121945_(facePrimary);
            posList.add(posPrimary);
            for (Direction faceSecondary : Direction.values()) {
                if (faceSecondary.m_122434_() == facePrimary.m_122434_() || !(Misc.random.nextDouble() < chance - 0.5)) continue;
                BlockPos posSecondary = posPrimary.m_121945_(faceSecondary);
                posList.add(posSecondary);
                for (Direction faceTertiary : Direction.values()) {
                    if (faceTertiary.m_122434_() == facePrimary.m_122434_() || faceTertiary.m_122434_() == faceSecondary.m_122434_() || !(Misc.random.nextDouble() < chance - 1.0)) continue;
                    BlockPos posTertiary = posSecondary.m_121945_(faceTertiary);
                    posList.add(posTertiary);
                }
            }
        }
        return posList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        if (!blastedEntities.contains(event.getEntity()) && event.getSource().m_7639_() != event.getEntity() && event.getSource().m_7640_() != event.getEntity()) {
            try {
                int blastingLevel;
                LivingEntity s;
                Player damager;
                Entity entity = event.getSource().m_7639_();
                if (entity instanceof Player) {
                    int blastingLevel2;
                    damager = (Player)entity;
                    blastedEntities.add((Entity)damager);
                    s = damager.m_21205_();
                    if (!s.m_41619_() && (blastingLevel2 = AugmentUtil.getAugmentLevel((ItemStack)s, this)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
                        double resonance = EmbersAPI.getEmberResonance((ItemStack)s);
                        float strength = (float)((resonance + 1.0) * (Math.atan(0.6 * (double)blastingLevel2) / Math.PI));
                        EmberInventoryUtil.removeEmber(damager, this.cost);
                        blastedEntities.add((Entity)event.getEntity());
                        List entities = damager.m_9236_().m_45976_(LivingEntity.class, new AABB(event.getEntity().m_20185_() - 4.0 * (double)strength, event.getEntity().m_20186_() - 4.0 * (double)strength, event.getEntity().m_20189_() - 4.0 * (double)strength, event.getEntity().m_20185_() + 4.0 * (double)strength, event.getEntity().m_20186_() + 4.0 * (double)strength, event.getEntity().m_20189_() + 4.0 * (double)strength));
                        double x = event.getEntity().m_20185_();
                        double y = event.getEntity().m_20186_() + (double)event.getEntity().m_20206_() / 2.0;
                        double z = event.getEntity().m_20189_();
                        blastedEntities.addAll(entities);
                        BlastingExplosion explosion = new BlastingExplosion(entities, event.getAmount() * strength, damager.m_9236_(), (Entity)damager, x, y, z, strength * 5.0f, false, Explosion.BlockInteraction.KEEP);
                        BlastingCoreAugment.spawnExplosion(damager.m_9236_(), explosion, x, y, z, strength * 1.5f);
                    }
                }
                if ((s = event.getEntity()) instanceof Player && (blastingLevel = AugmentUtil.getArmorAugmentLevel((LivingEntity)(damager = (Player)s), this)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
                    float strength = (float)(2.0 * (Math.atan(0.6 * (double)blastingLevel) / Math.PI));
                    EmberInventoryUtil.removeEmber(damager, this.cost);
                    List entities = damager.m_9236_().m_45976_(LivingEntity.class, new AABB(damager.m_20185_() - 4.0 * (double)strength, damager.m_20186_() - 4.0 * (double)strength, damager.m_20189_() - 4.0 * (double)strength, damager.m_20185_() + 4.0 * (double)strength, damager.m_20186_() + 4.0 * (double)strength, damager.m_20189_() + 4.0 * (double)strength));
                    double x = event.getEntity().m_20185_();
                    double y = event.getEntity().m_20186_() + (double)event.getEntity().m_20206_() / 2.0;
                    double z = event.getEntity().m_20189_();
                    blastedEntities.addAll(entities);
                    BlastingExplosion explosion = new BlastingExplosion(entities, event.getAmount() * strength * 0.25f, damager.m_9236_(), (Entity)damager, x, y, z, strength * 5.0f, false, Explosion.BlockInteraction.KEEP);
                    BlastingCoreAugment.spawnExplosion(damager.m_9236_(), explosion, x, y, z, strength * 1.5f);
                }
            }
            finally {
                blastedEntities.clear();
            }
        }
    }

    public static void spawnExplosion(Level level, Explosion explosion, double x, double y, double z, float radius) {
        if (!ForgeEventFactory.onExplosionStart((Level)level, (Explosion)explosion)) {
            explosion.m_46061_();
            explosion.m_46075_(true);
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (!explosion.m_254884_()) {
                    explosion.m_46080_();
                }
                for (ServerPlayer serverplayer : server.m_6907_()) {
                    if (!(serverplayer.m_20275_(x, y, z) < 4096.0)) continue;
                    serverplayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverplayer)));
                }
            }
        }
    }
}

