/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.augment.AugmentBase;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageCasterOrb;
import com.rekindled.embers.util.EmberInventoryUtil;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CasterOrbAugment
extends AugmentBase {
    public static float prevCooledStrength = 0.0f;
    public static float cooldownTicks = 0.0f;
    public static HashMap<UUID, Float> cooldownTicksServer = new HashMap();

    public CasterOrbAugment(ResourceLocation id) {
        super(id, 2.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void setCooldown(UUID uuid, float ticks) {
        cooldownTicksServer.put(uuid, Float.valueOf(ticks));
    }

    public static boolean hasCooldown(UUID uuid) {
        return cooldownTicksServer.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue() > 0.0f;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (UUID uuid : cooldownTicksServer.keySet()) {
                Float ticks = Float.valueOf(cooldownTicksServer.get(uuid).floatValue() - 1.0f);
                cooldownTicksServer.put(uuid, ticks);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                prevCooledStrength = mc.f_91074_.m_36403_(0.0f);
            }
            if (cooldownTicks > 0.0f) {
                cooldownTicks -= 1.0f;
            }
        }
    }

    @SubscribeEvent
    public void onSwing(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        Level world = event.getLevel();
        ItemStack heldStack = event.getItemStack();
        this.tryShoot(player, world, heldStack);
    }

    @SubscribeEvent
    public void onSwing(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        Level world = event.getLevel();
        ItemStack heldStack = event.getItemStack();
        this.tryShoot(player, world, heldStack);
    }

    private void tryShoot(Player player, Level world, ItemStack heldStack) {
        if (prevCooledStrength == 1.0f && AugmentUtil.hasHeat(heldStack)) {
            int level = AugmentUtil.getAugmentLevel(heldStack, this);
            if (world.m_5776_() && level > 0 && EmberInventoryUtil.getEmberTotal(player) > this.cost && cooldownTicks == 0.0f) {
                PacketHandler.INSTANCE.sendToServer((Object)new MessageCasterOrb(player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_));
                cooldownTicks = 20.0f;
            }
        }
    }
}

