/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.augment.AugmentBase;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.XRayGlowParticleOptions;
import com.rekindled.embers.util.EmberInventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ResonatingBellAugment
extends AugmentBase {
    public static HashMap<UUID, Float> cooldownTicksServer = new HashMap();

    public ResonatingBellAugment(ResourceLocation id) {
        super(id, 5.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void setCooldown(UUID uuid, float ticks) {
        cooldownTicksServer.put(uuid, Float.valueOf(ticks));
    }

    public static boolean hasCooldown(UUID uuid) {
        return cooldownTicksServer.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue() > 0.0f;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (UUID uuid : cooldownTicksServer.keySet()) {
                Float ticks = Float.valueOf(cooldownTicksServer.get(uuid).floatValue() - 1.0f);
                cooldownTicksServer.put(uuid, ticks);
            }
        }
    }

    @SubscribeEvent
    public void onClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack = event.getItemStack();
        Level world = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        if (AugmentUtil.hasHeat(heldStack)) {
            int level = AugmentUtil.getAugmentLevel(heldStack, this);
            UUID uuid = player.m_20148_();
            if (!world.m_5776_() && level > 0 && EmberInventoryUtil.getEmberTotal(player) >= this.cost && !ResonatingBellAugment.hasCooldown(uuid)) {
                double resonance = EmbersAPI.getEmberResonance(heldStack);
                int blockLimit = (int)((double)(150 * level) * resonance);
                int radius = (int)(1.0 + (double)(3 * level) * resonance);
                ResonatingBellAugment.setCooldown(uuid, 80.0f);
                BlockState state = world.m_8055_(pos);
                int count = 0;
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
                int baseX = pos.m_123341_();
                int baseY = pos.m_123342_();
                int baseZ = pos.m_123343_();
                for (int i = -radius; i <= radius; ++i) {
                    block1: for (int j = -radius; j <= radius; ++j) {
                        for (int k = -radius; k <= radius; ++k) {
                            mutablePos.m_122178_(baseX + i, baseY + j, baseZ + k);
                            if (world.m_8055_((BlockPos)mutablePos) != state) continue;
                            positions.add(mutablePos.m_7949_());
                            if (++count > blockLimit) continue block1;
                        }
                    }
                }
                if (count <= blockLimit) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        for (BlockPos p : positions) {
                            serverLevel.m_8767_((ParticleOptions)XRayGlowParticleOptions.EMBER_BIG_NOMOTION, (double)((float)p.m_123341_() + 0.5f), (double)((float)p.m_123342_() + 0.5f), (double)((float)p.m_123343_() + 0.5f), 3, 0.0625, 0.0625, 0.0625, 1.0);
                        }
                    }
                    world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)EmbersSounds.RESONATING_BELL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)EmbersSounds.RESONATING_BELL.get(), SoundSource.PLAYERS, 1.0f, 0.1f);
                }
                EmberInventoryUtil.removeEmber(player, this.cost);
            }
        }
    }
}

