/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.util.Misc;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BeamSplitterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape UP_AABB = Shapes.m_83110_((VoxelShape)BeamSplitterBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (VoxelShape)BeamSplitterBlock.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
    protected static final VoxelShape DOWN_AABB = Shapes.m_83110_((VoxelShape)BeamSplitterBlock.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)BeamSplitterBlock.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
    protected static final VoxelShape NORTH_AABB = Shapes.m_83110_((VoxelShape)BeamSplitterBlock.m_49796_((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)16.0), (VoxelShape)BeamSplitterBlock.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
    protected static final VoxelShape SOUTH_AABB = Shapes.m_83110_((VoxelShape)BeamSplitterBlock.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)3.0), (VoxelShape)BeamSplitterBlock.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
    protected static final VoxelShape WEST_AABB = Shapes.m_83110_((VoxelShape)BeamSplitterBlock.m_49796_((double)13.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (VoxelShape)BeamSplitterBlock.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
    protected static final VoxelShape EAST_AABB = Shapes.m_83110_((VoxelShape)BeamSplitterBlock.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), (VoxelShape)BeamSplitterBlock.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public BeamSplitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BeamSplitterBlock.canAttach(pLevel, pPos, ((Direction)pState.m_61143_((Property)FACING)).m_122424_());
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        return !pReader.m_8055_(pPos.m_121945_(pDirection)).m_60795_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        for (Direction direction : pContext.m_6232_()) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) continue;
            Direction.Axis axis = Direction.Axis.Z;
            for (Direction facing : Direction.m_122382_((Entity)pContext.m_43723_())) {
                if (facing.m_122434_() == direction.m_122434_()) continue;
                axis = Misc.getOtherAxis(direction.m_122434_(), facing.m_122434_());
                break;
            }
            return (BlockState)((BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return ((Direction)pState.m_61143_((Property)FACING)).m_122424_() == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{BlockStateProperties.f_61365_}).m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.BEAM_SPLITTER_ENTITY.get()).m_155264_(pPos, pState);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        Direction facing = rotation.m_55954_((Direction)state.m_61143_((Property)FACING));
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            if (state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Z) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
            } else if (axis == Direction.Axis.X) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
            }
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }
}

