/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.DialBaseBlock;
import com.rekindled.embers.blockentity.ItemDialBlockEntity;
import com.rekindled.embers.util.DecimalFormats;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class ItemDialBlock
extends DialBaseBlock {
    public static final String DIAL_TYPE = "item";

    public ItemDialBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        IItemHandler cap;
        BlockEntity blockEntity = level.m_7702_(pos.m_5484_((Direction)state.m_61143_((Property)f_52588_), -1));
        if (blockEntity != null && (cap = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, ((Direction)state.m_61143_((Property)f_52588_)).m_122424_()).orElse((Object)((IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null)))) != null) {
            double contents = 0.0;
            double capacity = 0.0;
            for (int i = 0; i < cap.getSlots(); ++i) {
                contents += (double)cap.getStackInSlot(i).m_41613_();
                capacity += (double)cap.getSlotLimit(i);
            }
            if (contents >= capacity) {
                return 15;
            }
            return (int)Math.ceil(14.0 * contents / capacity);
        }
        return 0;
    }

    @Override
    protected void getBEData(Direction facing, ArrayList<Component> text, BlockEntity blockEntity, int maxLines) {
        if (blockEntity instanceof ItemDialBlockEntity) {
            ItemDialBlockEntity dial = (ItemDialBlockEntity)blockEntity;
            if (dial.display) {
                for (int i = 0; i < dial.itemStacks.length && i < maxLines; ++i) {
                    text.add((Component)Component.m_237110_((String)"embers.tooltip.itemdial.slot", (Object[])new Object[]{i, ItemDialBlock.formatItemStack(dial.itemStacks[i])}));
                }
                if (dial.itemStacks.length + dial.extraLines > Math.min(maxLines, dial.itemStacks.length)) {
                    text.add((Component)Component.m_237110_((String)"embers.tooltip.too_many", (Object[])new Object[]{dial.itemStacks.length - Math.min(maxLines, dial.itemStacks.length) + dial.extraLines}));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent formatItemStack(ItemStack stack) {
        DecimalFormat stackFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.item_amount");
        if (!stack.m_41619_()) {
            return Component.m_237110_((String)"embers.tooltip.itemdial.item", (Object[])new Object[]{stackFormat.format(stack.m_41613_()), stack.m_41786_().getString()});
        }
        return Component.m_237115_((String)"embers.tooltip.itemdial.noitem");
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.ITEM_DIAL_ENTITY.get()).m_155264_(pPos, pState);
    }

    @Override
    public String getDialType() {
        return DIAL_TYPE;
    }
}

