/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class MechEdgeBlockBase
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<MechEdge> EDGE = EnumProperty.m_61587_((String)"edge", MechEdge.class);
    public static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape NORTH_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)2.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape NORTHEAST_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)2.0, (double)14.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape EAST_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape SOUTHEAST_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)14.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape SOUTH_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape SOUTHWEST_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape WEST_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape NORTHWEST_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TOP_AABB, BOTTOM_AABB});
    public static final VoxelShape[] SHAPES = new VoxelShape[]{NORTH_AABB, NORTHEAST_AABB, EAST_AABB, SOUTHEAST_AABB, SOUTH_AABB, SOUTHWEST_AABB, WEST_AABB, NORTHWEST_AABB};

    public MechEdgeBlockBase(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_(EDGE, (Comparable)((Object)MechEdge.NORTH)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockPos centerPos = pos.m_121955_(((MechEdge)((Object)state.m_61143_(MechEdgeBlockBase.EDGE))).centerPos);
            if (level.m_8055_(centerPos).m_60734_() == this.getCenterBlock()) {
                level.m_46961_(centerPos, false);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((MechEdge)((Object)state.m_61143_(MechEdgeBlockBase.EDGE))).index];
    }

    public abstract Block getCenterBlock();

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)this.getCenterBlock());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{EDGE}).m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(EDGE, (Comparable)((Object)((MechEdge)((Object)state.m_61143_(EDGE))).rotate(rotation)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_(EDGE, (Comparable)((Object)((MechEdge)((Object)state.m_61143_(EDGE))).mirror(mirror)));
    }

    public static enum MechEdge implements StringRepresentable
    {
        NORTH("north", 0, new Vec3i(0, 0, 1), false, 0),
        NORTHEAST("northeast", 1, new Vec3i(-1, 0, 1), true, 0),
        EAST("east", 2, new Vec3i(-1, 0, 0), false, 90),
        SOUTHEAST("southeast", 3, new Vec3i(-1, 0, -1), true, 90),
        SOUTH("south", 4, new Vec3i(0, 0, -1), false, 180),
        SOUTHWEST("southwest", 5, new Vec3i(1, 0, -1), true, 180),
        WEST("west", 6, new Vec3i(1, 0, 0), false, 270),
        NORTHWEST("northwest", 7, new Vec3i(1, 0, 1), true, 270);

        private final String name;
        public final int index;
        public final Vec3i centerPos;
        public final boolean corner;
        public final int rotation;
        public static MechEdge[] edges;
        public static MechEdge[] corners;
        public static HashMap<Vec3i, MechEdge> edgeByVec;
        public static HashMap<Vec3i, MechEdge> cornerByVec;

        private MechEdge(String name, int index, Vec3i center, boolean corner, int rotation) {
            this.name = name;
            this.index = index;
            this.centerPos = center;
            this.corner = corner;
            this.rotation = rotation;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public MechEdge rotate(Rotation rotation) {
            int angle = this.rotation;
            switch (rotation) {
                case NONE: {
                    return this;
                }
                case CLOCKWISE_90: {
                    angle += 90;
                    break;
                }
                case CLOCKWISE_180: {
                    angle += 180;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    angle += 270;
                }
            }
            angle = angle % 360 / 90;
            if (this.corner) {
                return corners[angle];
            }
            return edges[angle];
        }

        public MechEdge mirror(Mirror mirror) {
            Vec3i center = this.centerPos;
            switch (mirror) {
                case NONE: {
                    return this;
                }
                case FRONT_BACK: {
                    center = new Vec3i(-center.m_123341_(), center.m_123342_(), center.m_123343_());
                    break;
                }
                case LEFT_RIGHT: {
                    center = new Vec3i(center.m_123341_(), center.m_123342_(), -center.m_123343_());
                }
            }
            if (this.corner) {
                return cornerByVec.get(center);
            }
            return edgeByVec.get(center);
        }

        static {
            edges = new MechEdge[4];
            corners = new MechEdge[4];
            edgeByVec = new HashMap();
            cornerByVec = new HashMap();
            for (MechEdge edge : MechEdge.values()) {
                if (edge.corner) {
                    MechEdge.corners[edge.rotation / 90] = edge;
                    cornerByVec.put(edge.centerPos, edge);
                    continue;
                }
                MechEdge.edges[edge.rotation / 90] = edge;
                edgeByVec.put(edge.centerPos, edge);
            }
        }
    }
}

