/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.event.AlchemyResultEvent;
import com.rekindled.embers.api.event.AlchemyStartEvent;
import com.rekindled.embers.api.event.MachineRecipeEvent;
import com.rekindled.embers.api.misc.AlchemyResult;
import com.rekindled.embers.api.tile.IBin;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.ISparkable;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.AlchemyPedestalTopBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.AlchemyCircleParticleOptions;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.StarParticleOptions;
import com.rekindled.embers.recipe.AlchemyContext;
import com.rekindled.embers.recipe.IAlchemyRecipe;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class AlchemyTabletBlockEntity
extends BlockEntity
implements ISparkable,
ISoundController,
IExtraCapabilityInformation,
IUpgradeable {
    public static final Direction[] UPGRADE_SIDES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.DOWN};
    public static final int CONSUME_AMOUNT = 2;
    public static final int SPARK_THRESHOLD = 1000;
    public static final int PROCESSING_TIME = 40;
    public TabletItemStackHandler inventory = new TabletItemStackHandler(1, this);
    public IItemHandler outputHandler = new IItemHandler(){

        public int getSlots() {
            return AlchemyTabletBlockEntity.this.inventory.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return AlchemyTabletBlockEntity.this.inventory.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return AlchemyTabletBlockEntity.this.inventory.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (AlchemyTabletBlockEntity.this.outputMode) {
                return AlchemyTabletBlockEntity.this.inventory.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return AlchemyTabletBlockEntity.this.inventory.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return AlchemyTabletBlockEntity.this.inventory.isItemValid(slot, stack);
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    public LazyOptional<IItemHandler> outputHolder = LazyOptional.of(() -> this.outputHandler);
    public boolean outputMode = false;
    public int progress = 0;
    public int process = 0;
    static Random rand = new Random();
    public IAlchemyRecipe cachedRecipe = null;
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public AlchemyTabletBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.ALCHEMY_TABLET_ENTITY.get(), pPos, pBlockState);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(0, 0, 0), this.f_58858_.m_7918_(1, 2, 1));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("outputMode")) {
            this.outputMode = nbt.m_128471_("outputMode");
        }
        this.progress = nbt.m_128451_("progress");
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("outputMode", this.outputMode);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("progress", this.progress);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AlchemyTabletBlockEntity blockEntity) {
        blockEntity.handleSound();
        if (blockEntity.progress > 0) {
            if (blockEntity.process < 20) {
                ++blockEntity.process;
            }
            ArrayList<AlchemyPedestalTopBlockEntity> pedestals = AlchemyTabletBlockEntity.getNearbyPedestals(level, pos);
            for (AlchemyPedestalTopBlockEntity pedestal : pedestals) {
                pedestal.setActive(3);
                level.m_7106_((ParticleOptions)StarParticleOptions.EMBER, (double)((float)pedestal.m_58899_().m_123341_() + 0.5f), (double)((float)pedestal.m_58899_().m_123342_() + 0.75f), (double)((float)pedestal.m_58899_().m_123343_() + 0.5f), 0.0, 1.0E-5, 0.0);
                for (int j = 0; j < 16; ++j) {
                    float coeff = rand.nextFloat();
                    float x = ((float)pos.m_123341_() + 0.5f) * coeff + (1.0f - coeff) * ((float)pedestal.m_58899_().m_123341_() + 0.5f);
                    float y = ((float)pos.m_123342_() + 0.875f) * coeff + (1.0f - coeff) * ((float)pedestal.m_58899_().m_123342_() + 0.75f);
                    float z = ((float)pos.m_123343_() + 0.5f) * coeff + (1.0f - coeff) * ((float)pedestal.m_58899_().m_123343_() + 0.5f);
                    level.m_7106_((ParticleOptions)GlowParticleOptions.EMBER, (double)x, (double)y, (double)z, 0.0, 1.0E-5, 0.0);
                }
            }
            if (level.m_46467_() % 10L == 0L && pedestals.size() > 0) {
                AlchemyPedestalTopBlockEntity pedestal = (AlchemyPedestalTopBlockEntity)pedestals.get(rand.nextInt(pedestals.size()));
                float dx = (float)pos.m_123341_() + 0.5f - ((float)pedestal.m_58899_().m_123341_() + 0.5f);
                float dy = (float)pos.m_123342_() + 0.875f - ((float)pedestal.m_58899_().m_123342_() + 0.75f);
                float dz = (float)pos.m_123343_() + 0.5f - ((float)pedestal.m_58899_().m_123343_() + 0.5f);
                float speed = 0.5f;
                for (int j = 0; j < 20; ++j) {
                    level.m_7106_((ParticleOptions)StarParticleOptions.EMBER, (double)((float)pedestal.m_58899_().m_123341_() + 0.5f), (double)((float)pedestal.m_58899_().m_123342_() + 0.75f), (double)((float)pedestal.m_58899_().m_123343_() + 0.5f), (double)(dx * speed), (double)(dy * speed), (double)(dz * speed));
                }
            }
        } else if (blockEntity.progress == 0 && blockEntity.process > 0) {
            --blockEntity.process;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AlchemyTabletBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, UPGRADE_SIDES);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (blockEntity.progress > 0) {
            UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
            if (level.m_46467_() % 10L == 0L) {
                ArrayList<AlchemyPedestalTopBlockEntity> pedestals = AlchemyTabletBlockEntity.getNearbyPedestals(level, pos);
                if (blockEntity.progress < UpgradeUtil.getWorkTime(blockEntity, 40, blockEntity.upgrades)) {
                    ++blockEntity.progress;
                    blockEntity.m_6596_();
                } else {
                    ArrayList<IAlchemyRecipe.PedestalContents> contents = AlchemyTabletBlockEntity.getPedestalContents(pedestals);
                    AlchemyContext context = new AlchemyContext(blockEntity.inventory.getStackInSlot(0), contents, ((ServerLevel)level).m_7328_());
                    blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.ALCHEMY.get(), context, level);
                    if (blockEntity.cachedRecipe != null) {
                        IBin bin;
                        AlchemyResult result = blockEntity.cachedRecipe.getResult(context);
                        AlchemyResultEvent event = new AlchemyResultEvent(blockEntity, blockEntity.cachedRecipe, result, 2);
                        UpgradeUtil.throwEvent(blockEntity, event, blockEntity.upgrades);
                        ItemStack stack = event.isFailure() ? event.getResult().createResultStack(event.getResultStack().m_41777_()) : event.getResultStack().m_41777_();
                        SoundEvent finishSound = event.isFailure() ? (SoundEvent)EmbersSounds.ALCHEMY_FAIL.get() : (SoundEvent)EmbersSounds.ALCHEMY_SUCCESS.get();
                        level.m_5594_(null, pos, finishSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!event.isFailure()) {
                            UpgradeUtil.throwEvent(blockEntity, new MachineRecipeEvent.Success<IAlchemyRecipe>(blockEntity, blockEntity.cachedRecipe), blockEntity.upgrades);
                            for (AlchemyPedestalTopBlockEntity pedestal : pedestals) {
                                pedestal.inventory.setStackInSlot(0, ItemStack.f_41583_);
                            }
                        } else {
                            for (int i = 0; i < event.getConsumeAmount(); ++i) {
                                ((AlchemyPedestalTopBlockEntity)pedestals.get((int)AlchemyTabletBlockEntity.rand.nextInt((int)pedestals.size()))).inventory.setStackInSlot(0, ItemStack.f_41583_);
                            }
                        }
                        ((ServerLevel)level).m_8767_((ParticleOptions)new GlowParticleOptions(EmbersColors.EMBER_ID, 4.0f), (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_() + 0.875, (double)((float)pos.m_123343_() + 0.5f), 24, 0.1, 0.1, 0.1, 0.5);
                        blockEntity.progress = 0;
                        BlockEntity outputTile = level.m_7702_(pos.m_7495_());
                        if (outputTile instanceof IBin && (bin = (IBin)outputTile).getInventory().insertItem(0, stack, true).m_41619_()) {
                            blockEntity.inventory.extractItem(0, 1, false);
                            bin.getInventory().insertItem(0, stack, false);
                        } else {
                            blockEntity.outputMode = true;
                            blockEntity.inventory.extractItem(0, 1, false);
                            ItemStack remainder = blockEntity.inventory.forceInsertItem(0, stack, false);
                            if (!remainder.m_41619_()) {
                                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, remainder));
                            }
                            blockEntity.outputMode = true;
                        }
                    } else {
                        blockEntity.progress = 0;
                        blockEntity.m_6596_();
                    }
                }
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.outputHolder);
            }
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void sparkProgress(BlockEntity tile, double ember) {
        if (this.progress != 0 || ember < 1000.0) {
            return;
        }
        ArrayList<IAlchemyRecipe.PedestalContents> pedestals = AlchemyTabletBlockEntity.getPedestalContents(AlchemyTabletBlockEntity.getNearbyPedestals(this.f_58857_, this.f_58858_));
        AlchemyContext context = new AlchemyContext(this.inventory.getStackInSlot(0), pedestals, ((ServerLevel)this.f_58857_).m_7328_());
        this.cachedRecipe = Misc.getRecipe(this.cachedRecipe, (RecipeType)RegistryManager.ALCHEMY.get(), context, this.f_58857_);
        AlchemyStartEvent event = new AlchemyStartEvent(this, context, this.cachedRecipe);
        UpgradeUtil.throwEvent(this, event, this.upgrades);
        if (event.getRecipe() != null) {
            int time = UpgradeUtil.getWorkTime(this, 400, this.upgrades);
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)new AlchemyCircleParticleOptions(EmbersColors.EMBER_ID, 1.0f, time + 20), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.01, (double)this.f_58858_.m_123343_() + 0.5, 5, 0.0, 0.0, 0.0, 1.0);
            this.progress = 1;
            this.m_6596_();
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)EmbersSounds.ALCHEMY_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static ArrayList<IAlchemyRecipe.PedestalContents> getPedestalContents(List<AlchemyPedestalTopBlockEntity> pedestals) {
        ArrayList<IAlchemyRecipe.PedestalContents> contents = new ArrayList<IAlchemyRecipe.PedestalContents>();
        for (AlchemyPedestalTopBlockEntity pedestal : pedestals) {
            contents.add(pedestal.getContents());
        }
        return contents;
    }

    public static ArrayList<AlchemyPedestalTopBlockEntity> getNearbyPedestals(Level world, BlockPos pos) {
        ArrayList<AlchemyPedestalTopBlockEntity> pedestals = new ArrayList<AlchemyPedestalTopBlockEntity>();
        BlockPos.MutableBlockPos pedestalPos = pos.m_122032_();
        for (int i = -3; i < 4; ++i) {
            for (int j = -3; j < 4; ++j) {
                pedestalPos.m_122178_(pos.m_123341_() + i, pos.m_123342_() + 1, pos.m_123343_() + j);
                BlockEntity tile = world.m_7702_((BlockPos)pedestalPos);
                if (!(tile instanceof AlchemyPedestalTopBlockEntity) || !((AlchemyPedestalTopBlockEntity)tile).isValid()) continue;
                pedestals.add((AlchemyPedestalTopBlockEntity)tile);
            }
        }
        return pedestals;
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.ALCHEMY_LOOP.get(), SoundSource.BLOCKS, true, 1.5f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 1.0f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.progress > 0;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing == Direction.DOWN) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.alchemy_result")));
        } else {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", null));
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face != Direction.UP;
    }

    public static class TabletItemStackHandler
    extends ItemStackHandler {
        AlchemyTabletBlockEntity entity;

        public TabletItemStackHandler(int size, AlchemyTabletBlockEntity entity) {
            super(size);
            this.entity = entity;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack forceInsertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            int limit = 64;
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.m_41613_();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.m_41613_() > limit;
            if (!simulate) {
                if (existing.m_41619_()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                } else {
                    existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                }
                this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
        }

        protected void onContentsChanged(int slot) {
            if (this.getStackInSlot(slot).m_41619_()) {
                this.entity.outputMode = false;
            }
            this.entity.m_6596_();
        }
    }
}

