/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.blockentity.OpenTankBlockEntity;
import com.rekindled.embers.particle.VaporParticleOptions;
import com.rekindled.embers.util.Misc;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.joml.Vector3f;

public class FluidVesselBlockEntity
extends OpenTankBlockEntity {
    int ticksExisted = 0;
    public float renderOffset;
    int previousFluid;

    public FluidVesselBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.FLUID_VESSEL_ENTITY.get(), pPos, pBlockState);
        this.tank = new FluidTank((Integer)ConfigManager.FLUID_VESSEL_CAPACITY.get()){

            public void onContentsChanged() {
                FluidVesselBlockEntity.this.m_6596_();
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (Misc.isGaseousFluid(resource)) {
                    FluidVesselBlockEntity.this.setEscapedFluid(resource);
                    return resource.getAmount();
                }
                int filled = super.fill(resource, action);
                return filled;
            }
        };
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FluidVesselBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        if (blockEntity.ticksExisted == 1) {
            blockEntity.previousFluid = blockEntity.tank.getFluidAmount();
        }
        if (blockEntity.tank.getFluidAmount() != blockEntity.previousFluid) {
            blockEntity.renderOffset = blockEntity.renderOffset + (float)blockEntity.tank.getFluidAmount() - (float)blockEntity.previousFluid;
            blockEntity.previousFluid = blockEntity.tank.getFluidAmount();
        }
        if (blockEntity.shouldEmitParticles()) {
            blockEntity.updateEscapeParticles();
        }
    }

    @Override
    protected void updateEscapeParticles() {
        Vector3f color = IClientFluidTypeExtensions.of((FluidType)this.lastEscaped.getFluid().getFluidType()).modifyFogColor(Minecraft.m_91087_().f_91063_.m_109153_(), 0.0f, (ClientLevel)this.f_58857_, 6, 0.0f, new Vector3f(1.0f, 1.0f, 1.0f));
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.2f;
            float yOffset = 0.9f;
            float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.2f;
            this.f_58857_.m_7106_((ParticleOptions)new VaporParticleOptions(color, 2.0f), (double)((float)this.f_58858_.m_123341_() + xOffset), (double)((float)this.f_58858_.m_123342_() + yOffset), (double)((float)this.f_58858_.m_123343_() + zOffset), 0.0, (double)0.2f, 0.0);
        }
    }
}

