/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.projectile.EffectDamage;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.block.FluidDialBlock;
import com.rekindled.embers.blockentity.PipeBlockEntityBase;
import com.rekindled.embers.datagen.EmbersBlockTags;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.entity.EmberProjectileEntity;
import com.rekindled.embers.particle.VaporParticleOptions;
import com.rekindled.embers.recipe.FluidHandlerContext;
import com.rekindled.embers.recipe.IBoilingRecipe;
import com.rekindled.embers.upgrade.MiniBoilerUpgrade;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.joml.Vector3f;

public class MiniBoilerBlockEntity
extends PipeBlockEntityBase
implements ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final int SOUND_SLOW = 1;
    public static final int SOUND_MEDIUM = 2;
    public static final int SOUND_FAST = 3;
    public static final int SOUND_PRESSURE_LOW = 4;
    public static final int SOUND_PRESSURE_MEDIUM = 5;
    public static final int SOUND_PRESSURE_HIGH = 6;
    public static final int[] SOUND_IDS = new int[]{1, 2, 3, 4, 5, 6};
    Random random = new Random();
    HashSet<Integer> soundsPlaying = new HashSet();
    protected FluidTank fluidTank = new FluidTank((Integer)ConfigManager.MINI_BOILER_CAPACITY.get()){

        public void onContentsChanged() {
            MiniBoilerBlockEntity.this.m_6596_();
        }
    };
    public LazyOptional<IFluidHandler> fluidHolder = LazyOptional.of(() -> this.fluidTank);
    protected FluidTank gasTank = new FluidTank((Integer)ConfigManager.MINI_BOILER_CAPACITY.get()){

        public void onContentsChanged() {
            MiniBoilerBlockEntity.this.m_6596_();
        }
    };
    public LazyOptional<IFluidHandler> gasHolder = LazyOptional.of(() -> this.gasTank);
    protected MiniBoilerUpgrade upgrade = new MiniBoilerUpgrade(this);
    int lastBoil;
    int boilTime;
    public IBoilingRecipe cachedRecipe = null;

    public MiniBoilerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.MINI_BOILER_ENTITY.get(), pPos, pBlockState);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        Direction facing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61374_);
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == Direction.UP) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.gasHolder);
            }
            if (side == Direction.DOWN || side != facing) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.fluidHolder);
            }
        }
        if (cap == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && side == facing) {
            return this.upgrade.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidTank.readFromNBT(nbt.m_128469_("fluidTank"));
        this.gasTank.readFromNBT(nbt.m_128469_("gasTank"));
        this.lastBoil = nbt.m_128451_("lastBoil");
        this.boilTime = nbt.m_128451_("boilTime");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("fluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        nbt.m_128365_("gasTank", (Tag)this.gasTank.writeToNBT(new CompoundTag()));
        nbt.m_128405_("lastBoil", this.lastBoil);
        nbt.m_128405_("boilTime", this.boilTime);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("fluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        nbt.m_128365_("gasTank", (Tag)this.gasTank.writeToNBT(new CompoundTag()));
        nbt.m_128405_("lastBoil", this.lastBoil);
        nbt.m_128405_("boilTime", this.boilTime);
        return nbt;
    }

    @Override
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void initConnections() {
        Block block = this.f_58857_.m_8055_(this.f_58858_).m_60734_();
        for (Direction direction : Misc.horizontals) {
            BlockState facingState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction));
            BlockEntity facingBE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (facingState.m_204336_(EmbersBlockTags.FLUID_PIPE_CONNECTION)) {
                if (facingBE instanceof PipeBlockEntityBase && !((PipeBlockEntityBase)facingBE).getConnection((Direction)direction.m_122424_()).transfer) {
                    this.connections[direction.m_122411_()] = PipeBlockEntityBase.PipeConnection.NONE;
                    continue;
                }
                this.connections[direction.m_122411_()] = PipeBlockEntityBase.PipeConnection.PIPE;
                continue;
            }
            this.connections[direction.m_122411_()] = PipeBlockEntityBase.PipeConnection.NONE;
        }
        this.loaded = true;
        this.m_6596_();
        this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        this.f_58857_.m_46717_(this.f_58858_, block);
    }

    public int getCapacity() {
        return (Integer)ConfigManager.MINI_BOILER_CAPACITY.get();
    }

    public int getFluidAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int getGasAmount() {
        return this.gasTank.getFluidAmount();
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidTank getGasTank() {
        return this.gasTank;
    }

    public Fluid getFluid() {
        if (this.fluidTank.getFluid() != null) {
            return this.fluidTank.getFluid().getFluid();
        }
        return null;
    }

    public Fluid getGas() {
        if (this.gasTank.getFluid() != null) {
            return this.gasTank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.fluidTank.getFluid();
    }

    public FluidStack getGasStack() {
        return this.gasTank.getFluid();
    }

    public void boil(double heat) {
        FluidStack fluid = this.getFluidStack();
        FluidHandlerContext context = new FluidHandlerContext((IFluidHandler)this.fluidTank);
        this.cachedRecipe = Misc.getRecipe(this.cachedRecipe, (RecipeType)RegistryManager.BOILING.get(), context, this.f_58857_);
        if (this.cachedRecipe != null && fluid.getAmount() > 0 && heat > 0.0) {
            FluidStack gas;
            int fluidBoiled = Mth.m_14045_((int)((int)((Double)ConfigManager.MINI_BOILER_HEAT_MULTIPLIER.get() * heat)), (int)1, (int)fluid.getAmount());
            if (fluidBoiled > 0 && (gas = this.cachedRecipe.process(context, fluidBoiled)) != null) {
                int leftover = gas.getAmount() - this.gasTank.fill(gas, IFluidHandler.FluidAction.EXECUTE);
                if (((Boolean)ConfigManager.MINI_BOILER_CAN_EXPLODE.get()).booleanValue() && leftover > 0 && !this.f_58857_.m_5776_()) {
                    this.explode();
                }
            }
            this.lastBoil = fluidBoiled;
            this.boilTime = fluidBoiled / 200;
        }
    }

    public void explode() {
        double posX = (double)this.f_58858_.m_123341_() + 0.5;
        double posY = (double)this.f_58858_.m_123342_() + 0.5;
        double posZ = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)EmbersSounds.MINI_BOILER_RUPTURE.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        Explosion explosion = this.f_58857_.m_254849_(null, posX, posY, posZ, 3.0f, Level.ExplosionInteraction.NONE);
        this.f_58857_.m_7471_(this.f_58858_, false);
        EffectDamage effect = new EffectDamage(4.0f, preset -> this.f_58857_.m_269111_().m_269093_(explosion), 10, 0.0);
        for (int i = 0; i < 12; ++i) {
            EmberProjectileEntity proj = (EmberProjectileEntity)((EntityType)RegistryManager.EMBER_PROJECTILE.get()).m_20615_(this.f_58857_);
            proj.shoot(this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, 0.5f, 0.0f, 10.0);
            proj.m_6034_(posX, posY, posZ);
            proj.setLifetime(20 + this.random.nextInt(40));
            proj.setEffect(effect);
            this.f_58857_.m_7967_((Entity)proj);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, MiniBoilerBlockEntity blockEntity) {
        blockEntity.handleSound();
        blockEntity.spawnParticles();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MiniBoilerBlockEntity blockEntity) {
        if (!blockEntity.loaded) {
            blockEntity.initConnections();
        }
        if (blockEntity.boilTime > 0) {
            --blockEntity.boilTime;
            blockEntity.m_6596_();
        }
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        if ("fluid".equals(dialType) && facing.m_122434_() != Direction.Axis.Y) {
            ChatFormatting gasFormat = ChatFormatting.WHITE;
            if ((double)this.getGasAmount() > (double)this.getCapacity() * 0.8) {
                gasFormat = ChatFormatting.RED;
            } else if ((double)this.getGasAmount() > (double)this.getCapacity() * 0.5) {
                gasFormat = ChatFormatting.YELLOW;
            }
            information.add(0, (Component)FluidDialBlock.formatFluidStack(this.getGasStack(), this.getCapacity()).m_130940_(gasFormat));
        }
    }

    @Override
    public int getComparatorData(Direction facing, int data, String dialType) {
        if ("fluid".equals(dialType) && facing.m_122434_() != Direction.Axis.Y) {
            double fill = (double)this.getGasAmount() / (double)this.getCapacity();
            return fill > 0.0 ? (int)(1.0 + fill * 14.0) : 0;
        }
        return data;
    }

    public void spawnParticles() {
        double gasRatio = (double)this.getGasAmount() / (double)this.getCapacity();
        int spouts = 0;
        if (gasRatio > 0.8) {
            spouts = 3;
        } else if (gasRatio > 0.5) {
            spouts = 2;
        } else if (gasRatio > 0.25) {
            spouts = 1;
        }
        Vector3f color = IClientFluidTypeExtensions.of((FluidType)this.getGas().getFluidType()).modifyFogColor(Minecraft.m_91087_().f_91063_.m_109153_(), 0.0f, (ClientLevel)this.f_58857_, 6, 0.0f, new Vector3f(1.0f, 1.0f, 1.0f));
        Random posRand = new Random(this.f_58858_.m_121878_());
        for (int i = 0; i < spouts; ++i) {
            double angleA = posRand.nextDouble() * Math.PI * 2.0;
            double angleB = posRand.nextDouble() * Math.PI * 2.0;
            float xOffset = (float)(Math.cos(angleA) * Math.cos(angleB));
            float yOffset = (float)(Math.sin(angleA) * Math.cos(angleB));
            float zOffset = (float)Math.sin(angleB);
            float speed = 0.13875f;
            float vx = xOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vy = yOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vz = zOffset * speed + posRand.nextFloat() * speed * 0.3f;
            this.f_58857_.m_7106_((ParticleOptions)new VaporParticleOptions(color, new Vec3((double)vx, (double)vy, (double)vz), 1.0f), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.f_58858_.m_123341_() + 0.5f;
        float soundY = (float)this.f_58858_.m_123342_() + 0.5f;
        float soundZ = (float)this.f_58858_.m_123343_() + 0.5f;
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.MINI_BOILER_LOOP_SLOW.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 2: {
                EmbersSounds.playMachineSound(this, 2, (SoundEvent)EmbersSounds.MINI_BOILER_LOOP_MID.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 3: {
                EmbersSounds.playMachineSound(this, 3, (SoundEvent)EmbersSounds.MINI_BOILER_LOOP_FAST.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 4: {
                EmbersSounds.playMachineSound(this, 4, (SoundEvent)EmbersSounds.MINI_BOILER_PRESSURE_LOW.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 5: {
                EmbersSounds.playMachineSound(this, 5, (SoundEvent)EmbersSounds.MINI_BOILER_PRESSURE_MID.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 6: {
                EmbersSounds.playMachineSound(this, 6, (SoundEvent)EmbersSounds.MINI_BOILER_PRESSURE_HIGH.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        int speedId = 0;
        int pressureId = 0;
        int gasAmount = this.getGasAmount();
        double gasRatio = (double)gasAmount / (double)this.getCapacity();
        if (gasRatio > 0.8) {
            pressureId = 6;
        } else if (gasRatio > 0.5) {
            pressureId = 5;
        } else if (gasRatio > 0.25) {
            pressureId = 4;
        }
        if (this.boilTime > 0 && this.lastBoil > 0) {
            speedId = this.lastBoil >= 2400 ? 3 : (this.lastBoil >= 400 ? 2 : 1);
        }
        return speedId == id || pressureId == id;
    }

    @Override
    public float getCurrentPitch(int id, float pitch) {
        if (id == 5) {
            return 1.0f + ((float)this.getGasAmount() / (float)this.getCapacity() - 0.5f) * 1.7f;
        }
        if (id == 6) {
            return 1.0f + ((float)this.getGasAmount() / (float)this.getCapacity() - 0.8f) * 1.0f;
        }
        return pitch;
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHolder.invalidate();
        this.gasHolder.invalidate();
        this.upgrade.invalidate();
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.FLUID_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (facing == Direction.UP) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.fluid", (Component)Component.m_237115_((String)"embers.tooltip.goggles.fluid.steam")));
        } else if (facing == Direction.DOWN || facing != this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61374_)) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", (Component)Component.m_237115_((String)"embers.tooltip.goggles.fluid.water")));
        }
    }
}

