/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.blockentity.CrystalCellBlockEntity;
import com.rekindled.embers.render.EmbersRenderTypes;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class CrystalCellBlockEntityRenderer
implements BlockEntityRenderer<CrystalCellBlockEntity> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/block/crystal_material.png");
    Random random = new Random();

    public CrystalCellBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(CrystalCellBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.random.setSeed(blockEntity.seed);
        float capacityFactor = 120000.0f;
        double emberCapacity = blockEntity.renderCapacity;
        double lerpCapacity = emberCapacity * (double)partialTick + blockEntity.renderCapacityLast * (double)(1.0f - partialTick);
        int numLayers = 2 + (int)Math.floor(lerpCapacity / (double)capacityFactor) + 1;
        int numLayersOld = numLayers - 1;
        float growthFactor = this.getGrowthFactor(capacityFactor, lerpCapacity);
        float layerHeight = 0.25f;
        float height = layerHeight * (float)numLayers * growthFactor + (float)numLayersOld * layerHeight * (1.0f - growthFactor);
        float[] widths = new float[numLayers + 1];
        float[] oldWidths = new float[numLayers + 1];
        for (float i = 0.0f; i < (float)(numLayers + 1); i += 1.0f) {
            float rand = this.random.nextFloat();
            widths[(int)i] = i < (float)numLayers / 2.0f ? i / ((float)numLayers / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayers : ((float)numLayers - i) / ((float)numLayers / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayers;
            if (i >= (float)numLayersOld) continue;
            oldWidths[(int)i] = (double)i < (double)numLayersOld / 2.0 ? i / ((float)numLayersOld / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayersOld : ((float)numLayersOld - i) / ((float)numLayersOld / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayersOld;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.disableCull();
        VertexConsumer buffer = bufferSource.m_6299_((Boolean)ConfigManager.RENDER_FALLBACK.get() != false ? EmbersRenderTypes.CRYSTAL_FALLBACK : EmbersRenderTypes.CRYSTAL);
        for (float j = 0.0f; j < 12.0f; j += 1.0f) {
            poseStack.m_85836_();
            float scale = j / 12.0f;
            poseStack.m_85837_(0.5, (double)(height / 2.0f) + 1.5, 0.5);
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(partialTick + (float)(blockEntity.ticksExisted % 360L)));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f * (float)Math.sin(Math.toRadians(partialTick / 3.0f + (float)blockEntity.ticksExisted / 3.0f % 360.0f))));
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            for (int i = 0; i < widths.length - 1; ++i) {
                float width = widths[i] * growthFactor + oldWidths[i] * (1.0f - growthFactor);
                float nextWidth = widths[i + 1] * growthFactor + oldWidths[i + 1] * (1.0f - growthFactor);
                buffer.m_252986_(matrix4f, -width, layerHeight * (float)i - height / 2.0f, -width).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, width, layerHeight * (float)i - height / 2.0f, -width).m_7421_(0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, -nextWidth).m_7421_(0.5f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, -nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, -nextWidth).m_7421_(0.0f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, -width, layerHeight * (float)i - height / 2.0f, width).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, width, layerHeight * (float)i - height / 2.0f, width).m_7421_(0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, nextWidth).m_7421_(0.5f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, -nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, nextWidth).m_7421_(0.0f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, -width, layerHeight * (float)i - height / 2.0f, -width).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, -width, layerHeight * (float)i - height / 2.0f, width).m_7421_(0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, -nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, nextWidth).m_7421_(0.5f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, -nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, -nextWidth).m_7421_(0.0f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, width, layerHeight * (float)i - height / 2.0f, -width).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, width, layerHeight * (float)i - height / 2.0f, width).m_7421_(0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, nextWidth).m_7421_(0.5f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
                buffer.m_252986_(matrix4f, nextWidth, layerHeight + layerHeight * (float)i - height / 2.0f, -nextWidth).m_7421_(0.0f, 0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.65f).m_5752_();
            }
            poseStack.m_85849_();
        }
        RenderSystem.enableCull();
    }

    private float getGrowthFactor(float capacityFactor, double emberCapacity) {
        return (float)(emberCapacity % (double)capacityFactor) / capacityFactor;
    }
}

