/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.rekindled.embers.blockentity.MelterTopBlockEntity;
import com.rekindled.embers.render.FluidCuboid;
import com.rekindled.embers.render.FluidRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Vector3f;

public class MelterTopBlockEntityRenderer
implements BlockEntityRenderer<MelterTopBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final RandomSource random = RandomSource.m_216327_();
    FluidCuboid cube = new FluidCuboid(new Vector3f(4.0f, 0.0f, 4.0f), new Vector3f(12.0f, 14.0f, 12.0f), FluidCuboid.DEFAULT_FACES);

    public MelterTopBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.itemRenderer = pContext.m_234447_();
    }

    public void render(MelterTopBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity != null) {
            for (int i = 0; i < blockEntity.inventory.getSlots(); ++i) {
                if (blockEntity.inventory.getStackInSlot(i).m_41619_()) continue;
                poseStack.m_85836_();
                ItemStack stack = blockEntity.inventory.getStackInSlot(i);
                int seed = stack.m_41619_() ? 187 : Item.m_41393_((Item)stack.m_41720_()) + stack.m_41773_();
                this.random.m_188584_((long)seed);
                BakedModel bakedmodel = this.itemRenderer.m_174264_(stack, blockEntity.m_58904_(), null, seed);
                boolean flag = bakedmodel.m_7539_();
                int j = this.getRenderAmount(stack);
                float f2 = bakedmodel.m_7442_().m_269404_((ItemDisplayContext)ItemDisplayContext.GROUND).f_111757_.y();
                poseStack.m_85837_(0.5, (double)(0.25f * f2), 0.5);
                float f3 = ((float)blockEntity.angle + partialTick) / 20.0f;
                poseStack.m_252781_(Axis.f_252436_.m_252961_(f3));
                if (!flag) {
                    float f7 = -0.0f * (float)(j - 1) * 0.5f;
                    float f8 = -0.0f * (float)(j - 1) * 0.5f;
                    float f9 = -0.09375f * (float)(j - 1) * 0.5f;
                    poseStack.m_85837_((double)f7, (double)f8, (double)f9);
                }
                for (int k = 0; k < j; ++k) {
                    poseStack.m_85836_();
                    if (k > 0) {
                        if (flag) {
                            float f11 = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                            float f13 = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                            float f10 = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                            poseStack.m_252880_(f11, f13, f10);
                        } else {
                            float f12 = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                            float f14 = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                            poseStack.m_85837_((double)f12, (double)f14, 0.0);
                        }
                    }
                    this.itemRenderer.m_115143_(stack, ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_, bakedmodel);
                    poseStack.m_85849_();
                    if (flag) continue;
                    poseStack.m_85837_(0.0, 0.0, 0.09375);
                }
                poseStack.m_85849_();
            }
            FluidStack fluidStack = blockEntity.getFluidStack();
            int capacity = blockEntity.getCapacity();
            if (!fluidStack.isEmpty() && capacity > 0) {
                float offset = blockEntity.renderOffset;
                if (offset > 1.2f || offset < -1.2f) {
                    offset -= (offset / 12.0f + 0.1f) * partialTick;
                    blockEntity.renderOffset = offset;
                } else {
                    blockEntity.renderOffset = 0.0f;
                }
                FluidRenderer.renderScaledCuboid(poseStack, bufferSource, this.cube, fluidStack, offset, capacity, packedLight, packedOverlay, false);
            } else {
                blockEntity.renderOffset = 0.0f;
            }
        }
    }

    protected int getRenderAmount(ItemStack pStack) {
        int i = 1;
        if (pStack.m_41613_() > 48) {
            i = 5;
        } else if (pStack.m_41613_() > 32) {
            i = 4;
        } else if (pStack.m_41613_() > 16) {
            i = 3;
        } else if (pStack.m_41613_() > 1) {
            i = 2;
        }
        return i;
    }
}

