/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.compat.jei;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.compat.jei.IngotTooltipCallback;
import com.rekindled.embers.compat.jei.JEIPlugin;
import com.rekindled.embers.recipe.IGaseousFuelRecipe;
import com.rekindled.embers.util.DecimalFormats;
import com.rekindled.embers.util.Misc;
import java.text.DecimalFormat;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GaseousFuelCategory
implements IRecipeCategory<IGaseousFuelRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    public static Component title = Component.m_237115_((String)"embers.jei.recipe.gaseous_fuel");
    public static ResourceLocation texture = new ResourceLocation("embers", "textures/gui/jei_gaseous_fuel.png");

    public GaseousFuelCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 126, 31);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryManager.WILDFIRE_STIRLING_ITEM.get()));
    }

    public RecipeType<IGaseousFuelRecipe> getRecipeType() {
        return JEIPlugin.GASEOUS_FUEL;
    }

    public Component getTitle() {
        return title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IGaseousFuelRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 7).addTooltipCallback((IRecipeSlotTooltipCallback)IngotTooltipCallback.INSTANCE).setFluidRenderer((long)recipe.getDisplayInput().getFluids().get(0).getAmount(), false, 16, 16).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getDisplayInput().getFluids());
    }

    public void draw(IGaseousFuelRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        DecimalFormat multiplierFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.ember_multiplier");
        Misc.drawComponents(Minecraft.m_91087_().f_91062_, guiGraphics, 28, 5, new Component[]{Component.m_237110_((String)"embers.jei.recipe.gaseous_fuel.burn_time", (Object[])new Object[]{recipe.getDisplayBurnTime()})});
        Misc.drawComponents(Minecraft.m_91087_().f_91062_, guiGraphics, 28, 17, new Component[]{Component.m_237110_((String)"embers.jei.recipe.gaseous_fuel.power_multiplier", (Object[])new Object[]{multiplierFormat.format(recipe.getDisplayMultiplier())})});
    }
}

