/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.compat.jei;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.compat.jei.AlchemyCategory;
import com.rekindled.embers.compat.jei.BoilingCategory;
import com.rekindled.embers.compat.jei.BoringCategory;
import com.rekindled.embers.compat.jei.CatalysisCombustionCategory;
import com.rekindled.embers.compat.jei.DawnstoneAnvilCategory;
import com.rekindled.embers.compat.jei.EmberActivationCategory;
import com.rekindled.embers.compat.jei.ExcavationCategory;
import com.rekindled.embers.compat.jei.GaseousFuelCategory;
import com.rekindled.embers.compat.jei.MeltingBonusCategory;
import com.rekindled.embers.compat.jei.MeltingCategory;
import com.rekindled.embers.compat.jei.MetalCoefficientCategory;
import com.rekindled.embers.compat.jei.MixingCategory;
import com.rekindled.embers.compat.jei.StampingCategory;
import com.rekindled.embers.recipe.IAlchemyRecipe;
import com.rekindled.embers.recipe.IBoilingRecipe;
import com.rekindled.embers.recipe.IBoringRecipe;
import com.rekindled.embers.recipe.ICatalysisCombustionRecipe;
import com.rekindled.embers.recipe.IDawnstoneAnvilRecipe;
import com.rekindled.embers.recipe.IEmberActivationRecipe;
import com.rekindled.embers.recipe.IGaseousFuelRecipe;
import com.rekindled.embers.recipe.IMeltingRecipe;
import com.rekindled.embers.recipe.IMetalCoefficientRecipe;
import com.rekindled.embers.recipe.IMixingRecipe;
import com.rekindled.embers.recipe.IStampingRecipe;
import com.rekindled.embers.recipe.IVisuallySplitRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static ResourceLocation pluginID = new ResourceLocation("embers", "jei_plugin");
    public static final RecipeType<IBoringRecipe> BORING = RecipeType.create((String)"embers", (String)"boring", IBoringRecipe.class);
    public static final RecipeType<IBoringRecipe> EXCAVATION = RecipeType.create((String)"embers", (String)"excavation", IBoringRecipe.class);
    public static final RecipeType<IEmberActivationRecipe> EMBER_ACTIVATION = RecipeType.create((String)"embers", (String)"ember_activation", IEmberActivationRecipe.class);
    public static final RecipeType<IMeltingRecipe> MELTING = RecipeType.create((String)"embers", (String)"melting", IMeltingRecipe.class);
    public static final RecipeType<IMeltingRecipe> MELTING_BONUS = RecipeType.create((String)"embers", (String)"melting_bonus", IMeltingRecipe.class);
    public static final RecipeType<IStampingRecipe> STAMPING = RecipeType.create((String)"embers", (String)"stamping", IStampingRecipe.class);
    public static final RecipeType<IMixingRecipe> MIXING = RecipeType.create((String)"embers", (String)"mixing", IMixingRecipe.class);
    public static final RecipeType<IMetalCoefficientRecipe> METAL_COEFFICIENT = RecipeType.create((String)"embers", (String)"metal_coefficient", IMetalCoefficientRecipe.class);
    public static final RecipeType<IAlchemyRecipe> ALCHEMY = RecipeType.create((String)"embers", (String)"alchemy", IAlchemyRecipe.class);
    public static final RecipeType<IBoilingRecipe> BOILING = RecipeType.create((String)"embers", (String)"boiling", IBoilingRecipe.class);
    public static final RecipeType<IGaseousFuelRecipe> GASEOUS_FUEL = RecipeType.create((String)"embers", (String)"gaseous_fuel", IGaseousFuelRecipe.class);
    public static final RecipeType<ICatalysisCombustionRecipe> CATALYSIS_COMBUSTION = RecipeType.create((String)"embers", (String)"catalysis_combustion", ICatalysisCombustionRecipe.class);
    public static final RecipeType<IDawnstoneAnvilRecipe> DAWNSTONE_ANVIL = RecipeType.create((String)"embers", (String)"dawnstone_anvil", IDawnstoneAnvilRecipe.class);

    public ResourceLocation getPluginUid() {
        return pluginID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BoringCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ExcavationCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EmberActivationCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingBonusCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new StampingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MixingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MetalCoefficientCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlchemyCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BoilingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GaseousFuelCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CatalysisCombustionCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DawnstoneAnvilCategory(guiHelper)});
    }

    public static <C extends Container, T extends Recipe<C>> void addRecipes(IRecipeRegistration register, RecipeManager manager, RecipeType<T> jeiType, net.minecraft.world.item.crafting.RecipeType<T> type) {
        List recipes = manager.m_44013_(type);
        ArrayList<Object> visualRecipes = new ArrayList<Object>();
        for (Recipe recipe : recipes) {
            if (recipe instanceof IVisuallySplitRecipe) {
                visualRecipes.addAll(((IVisuallySplitRecipe)recipe).getVisualRecipes());
                continue;
            }
            visualRecipes.add(recipe);
        }
        register.addRecipes(jeiType, visualRecipes);
    }

    public void registerRecipes(IRecipeRegistration register) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        JEIPlugin.addRecipes(register, manager, BORING, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.BORING.get());
        JEIPlugin.addRecipes(register, manager, EXCAVATION, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.EXCAVATION.get());
        JEIPlugin.addRecipes(register, manager, EMBER_ACTIVATION, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.EMBER_ACTIVATION.get());
        List meltingRecipes = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RegistryManager.MELTING.get());
        register.addRecipes(MELTING, meltingRecipes);
        ArrayList<IMeltingRecipe> meltingBonusRecipes = new ArrayList<IMeltingRecipe>();
        for (IMeltingRecipe recipe : meltingRecipes) {
            if (recipe.getBonus().isEmpty()) continue;
            meltingBonusRecipes.add(recipe);
        }
        register.addRecipes(MELTING_BONUS, meltingBonusRecipes);
        JEIPlugin.addRecipes(register, manager, STAMPING, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.STAMPING.get());
        JEIPlugin.addRecipes(register, manager, MIXING, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.MIXING.get());
        JEIPlugin.addRecipes(register, manager, METAL_COEFFICIENT, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.METAL_COEFFICIENT.get());
        JEIPlugin.addRecipes(register, manager, ALCHEMY, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.ALCHEMY.get());
        JEIPlugin.addRecipes(register, manager, BOILING, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.BOILING.get());
        JEIPlugin.addRecipes(register, manager, GASEOUS_FUEL, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.GASEOUS_FUEL.get());
        JEIPlugin.addRecipes(register, manager, CATALYSIS_COMBUSTION, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.CATALYSIS_COMBUSTION.get());
        JEIPlugin.addRecipes(register, manager, DAWNSTONE_ANVIL, (net.minecraft.world.item.crafting.RecipeType)RegistryManager.DAWNSTONE_ANVIL_RECIPE.get());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.EMBER_BORE_ITEM.get()), new RecipeType[]{BORING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.EMBER_BORE_ITEM.get()), new RecipeType[]{EXCAVATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.EXCAVATION_BUCKETS_ITEM.get()), new RecipeType[]{EXCAVATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.EMBER_ACTIVATOR_ITEM.get()), new RecipeType[]{EMBER_ACTIVATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.PRESSURE_REFINERY_ITEM.get()), new RecipeType[]{EMBER_ACTIVATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.IGNEM_REACTOR_ITEM.get()), new RecipeType[]{EMBER_ACTIVATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.MELTER_ITEM.get()), new RecipeType[]{MELTING, MELTING_BONUS});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.GEOLOGIC_SEPARATOR_ITEM.get()), new RecipeType[]{MELTING_BONUS});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.STAMPER_ITEM.get()), new RecipeType[]{STAMPING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.STAMP_BASE_ITEM.get()), new RecipeType[]{STAMPING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.MIXER_CENTRIFUGE_ITEM.get()), new RecipeType[]{MIXING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.PRESSURE_REFINERY_ITEM.get()), new RecipeType[]{METAL_COEFFICIENT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.HEARTH_COIL_ITEM.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.HEARTH_COIL_ITEM.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.CHAR_INSTILLER.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.HEARTH_COIL_ITEM.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.ATMOSPHERIC_BELLOWS.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.ALCHEMY_PEDESTAL_ITEM.get()), new RecipeType[]{ALCHEMY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.ALCHEMY_TABLET_ITEM.get()), new RecipeType[]{ALCHEMY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.BEAM_CANNON_ITEM.get()), new RecipeType[]{ALCHEMY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.MINI_BOILER_ITEM.get()), new RecipeType[]{BOILING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.CATALYTIC_PLUG_ITEM.get()), new RecipeType[]{GASEOUS_FUEL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.WILDFIRE_STIRLING_ITEM.get()), new RecipeType[]{GASEOUS_FUEL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.TINKER_HAMMER.get()), new RecipeType[]{DAWNSTONE_ANVIL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.DAWNSTONE_ANVIL_ITEM.get()), new RecipeType[]{DAWNSTONE_ANVIL});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryManager.AUTOMATIC_HAMMER_ITEM.get()), new RecipeType[]{DAWNSTONE_ANVIL});
    }
}

