/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.datagen;

import com.rekindled.embers.datagen.EmbersConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class EmbersPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ORE_LEAD_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("embers", "ore_lead_placer"));
    public static final List<PlacementModifier> ORE_LEAD_PLACEMENT = EmbersPlacedFeatures.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-28), (VerticalAnchor)VerticalAnchor.m_158922_((int)28)));
    public static final ResourceKey<PlacedFeature> ORE_SILVER_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("embers", "ore_silver_placer"));
    public static final List<PlacementModifier> ORE_SILVER_PLACEMENT = EmbersPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)64)));

    public static void generate(BootstapContext<PlacedFeature> bootstrap) {
        HolderGetter configured = bootstrap.m_255420_(Registries.f_256911_);
        bootstrap.m_255272_(ORE_LEAD_KEY, (Object)new PlacedFeature((Holder)configured.m_255043_(EmbersConfiguredFeatures.ORE_LEAD_KEY), ORE_LEAD_PLACEMENT));
        bootstrap.m_255272_(ORE_SILVER_KEY, (Object)new PlacedFeature((Holder)configured.m_255043_(EmbersConfiguredFeatures.ORE_SILVER_KEY), ORE_SILVER_PLACEMENT));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return EmbersPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)pCount), pHeightRange);
    }

    public static List<PlacementModifier> rareOrePlacement(int pChance, PlacementModifier pHeightRange) {
        return EmbersPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)pChance), pHeightRange);
    }
}

