/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.datagen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.datagen.EmbersBiomeModifiers;
import com.rekindled.embers.worldgen.CaveStructure;
import com.rekindled.embers.worldgen.CrystalSeedStructureProcessor;
import com.rekindled.embers.worldgen.EntityMobilizerStructureProcessor;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;

public class EmbersStructures {
    public static final ResourceKey<StructureProcessorList> RUIN_PROCESSORS = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("embers", "small_ruin"));
    public static final ResourceKey<StructureTemplatePool> SMALL_RUIN_POOL = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("embers", "small_ruin"));
    public static final ResourceKey<Structure> SMALL_RUIN = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("embers", "small_ruin"));
    public static final ResourceKey<StructureSet> SMALL_RUIN_SET = ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("embers", "small_ruin"));

    public static void generateProcessors(BootstapContext<StructureProcessorList> bootstrap) {
        bootstrap.m_255272_(RUIN_PROCESSORS, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{new CrystalSeedStructureProcessor(210000, 5050000, 900), EntityMobilizerStructureProcessor.INSTANCE})));
    }

    public static void generatePools(BootstapContext<StructureTemplatePool> bootstrap) {
        HolderGetter templatePool = bootstrap.m_255420_(Registries.f_256948_);
        HolderGetter processor = bootstrap.m_255420_(Registries.f_257011_);
        Holder.Reference empty = templatePool.m_255043_(Pools.f_127186_);
        Holder.Reference ruinProcessor = processor.m_255043_(RUIN_PROCESSORS);
        bootstrap.m_255272_(SMALL_RUIN_POOL, (Object)new StructureTemplatePool((Holder)empty, (List)Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)SinglePoolElement.m_210531_((String)"embers:small_ruin_copper", (Holder)ruinProcessor), (Object)2), Pair.of((Object)SinglePoolElement.m_210531_((String)"embers:small_ruin_iron", (Holder)ruinProcessor), (Object)2), Pair.of((Object)SinglePoolElement.m_210531_((String)"embers:small_ruin_gold", (Holder)ruinProcessor), (Object)1), Pair.of((Object)SinglePoolElement.m_210531_((String)"embers:small_ruin_lead", (Holder)ruinProcessor), (Object)2), Pair.of((Object)SinglePoolElement.m_210531_((String)"embers:small_ruin_silver", (Holder)ruinProcessor), (Object)1)}), StructureTemplatePool.Projection.RIGID));
    }

    public static void generateStructures(BootstapContext<Structure> bootstrap) {
        HolderGetter templatePool = bootstrap.m_255420_(Registries.f_256948_);
        HolderGetter biome = bootstrap.m_255420_(ForgeRegistries.Keys.BIOMES);
        HolderSet.Named overworldBiomes = biome.m_254956_(BiomeTags.f_215817_);
        List<HolderSet.Named> biomeBlackList = List.of(biome.m_254956_(Tags.Biomes.IS_MUSHROOM), HolderSet.m_205809_((Holder[])new Holder[]{biome.m_255043_(Biomes.f_220594_)}), biome.m_254956_(EmbersBiomeModifiers.NO_MONSTERS));
        AndHolderSet ruinSpawns = new AndHolderSet(List.of(overworldBiomes, new EmbersBiomeModifiers.NotHolderSetWrapper(new OrHolderSet(biomeBlackList))));
        bootstrap.m_255272_(SMALL_RUIN, (Object)new CaveStructure(new Structure.StructureSettings((HolderSet)ruinSpawns, Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)RegistryManager.ANCIENT_GOLEM.get(), 20, 1, 1)}))), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE), (Holder<StructureTemplatePool>)templatePool.m_255043_(SMALL_RUIN_POOL), 2, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10)), (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158930_((int)128)), false, Heightmap.Types.OCEAN_FLOOR_WG));
    }

    public static void generateSets(BootstapContext<StructureSet> bootstrap) {
        HolderGetter structure = bootstrap.m_255420_(Registries.f_256944_);
        bootstrap.m_255272_(SMALL_RUIN_SET, (Object)new StructureSet((Holder)structure.m_255043_(SMALL_RUIN), (StructurePlacement)new RandomSpreadStructurePlacement(7, 1, RandomSpreadType.LINEAR, 193826405)));
    }
}

