/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.fluidtypes;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.rekindled.embers.fluidtypes.EmbersFluidType;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.joml.Vector3f;

public class SteamFluidType
extends EmbersFluidType {
    public SteamFluidType(FluidType.Properties properties, EmbersFluidType.FluidInfo info) {
        super(properties, info);
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        entity.m_6469_(entity.m_9236_().m_269111_().m_269387_(), 1.0f);
        entity.m_9236_().m_46473_().m_6180_("jump");
        if (entity.f_20899_) {
            boolean flag = entity.m_20069_();
            if (!flag || entity.m_20096_()) {
                if (!entity.m_20077_() || entity.m_20096_()) {
                    if ((entity.m_20096_() || flag) && entity.f_20954_ == 0) {
                        SteamFluidType.jumpFromGround(entity);
                        entity.f_20954_ = 10;
                    }
                } else {
                    entity.jumpInFluid((FluidType)ForgeMod.LAVA_TYPE.get());
                }
            } else {
                entity.jumpInFluid((FluidType)ForgeMod.WATER_TYPE.get());
            }
        } else {
            entity.f_20954_ = 0;
        }
        entity.m_9236_().m_46473_().m_7238_();
        float f2 = 0.6f;
        float f3 = entity.m_20096_() ? f2 * 0.91f : 0.91f;
        Vec3 vec35 = entity.m_21074_(movementVector, f2);
        double d2 = vec35.f_82480_;
        if (entity.m_21023_(MobEffects.f_19620_)) {
            d2 += (0.05 * (double)(entity.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - vec35.f_82480_) * 0.2;
            entity.m_183634_();
        } else if (entity.m_9236_().m_5776_() && !entity.m_9236_().m_46805_(entity.m_20183_())) {
            d2 = entity.m_20186_() > (double)entity.m_9236_().m_141937_() ? -0.1 : 0.0;
        } else if (!entity.m_20068_()) {
            d2 -= gravity;
        }
        vec35 = entity.m_147223_() ? new Vec3(vec35.f_82479_, d2, vec35.f_82481_) : new Vec3(vec35.f_82479_ * (double)f3, d2 * (double)0.98f, vec35.f_82481_ * (double)f3);
        entity.m_20256_(vec35);
        return true;
    }

    static void jumpFromGround(LivingEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_, (double)(0.42f + entity.m_285755_()), vec3.f_82481_);
        if (entity.m_20142_()) {
            float f = entity.m_146908_() * ((float)Math.PI / 180);
            entity.m_20256_(entity.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f) * 0.2f)));
        }
        entity.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)entity);
    }

    @Override
    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return SteamFluidType.this.TEXTURE_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return SteamFluidType.this.TEXTURE_FLOW;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return SteamFluidType.this.FOG_COLOR;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)SteamFluidType.this.fogStart);
                float[] color = RenderSystem.getShaderFogColor();
                RenderSystem.setShaderFogColor((float)color[0], (float)color[1], (float)color[2], (float)0.7f);
                RenderSystem.setShaderFogEnd((float)SteamFluidType.this.fogEnd);
            }
        });
    }
}

