/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.gui;

import com.rekindled.embers.gui.SlateMenu;
import com.rekindled.embers.item.AlchemyHintItem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlateScreen
extends AbstractContainerScreen<SlateMenu> {
    ResourceLocation inventory = new ResourceLocation("embers", "textures/gui/inventory_gui.png");
    ResourceLocation slate = new ResourceLocation("embers", "textures/gui/codebreaking_slate_gui.png");
    public static int slotOffset = SlateMenu.slotIndent + 3;

    public SlateScreen(SlateMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97727_ = SlateMenu.invHeight + SlateMenu.slateHeight;
        this.f_97726_ = SlateMenu.invWidth;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(graphics, pMouseX, pMouseY);
    }

    public void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int invX = (this.f_96543_ - this.f_97726_) / 2;
        int x = (this.f_96543_ - SlateMenu.slateWidth) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(this.inventory, invX, y + SlateMenu.slateHeight, 0, 0, SlateMenu.invWidth, SlateMenu.invHeight);
        graphics.m_280218_(this.slate, x, y, 0, 0, SlateMenu.slateWidth, SlateMenu.slateHeight);
        ItemStack baseStack = ((SlateMenu)this.f_97732_).m_38853_(0).m_7993_();
        ArrayList<ItemStack> inputs = AlchemyHintItem.getInputs(baseStack);
        for (int j = 0; j < inputs.size(); ++j) {
            int slotX = x + SlateMenu.widthMargin + j * SlateMenu.layerWidth / inputs.size() + SlateMenu.layerWidth / (2 * inputs.size()) - 12;
            graphics.m_280218_(this.slate, slotX, y + SlateMenu.heightMargin, 192, 0, 24, 24);
            graphics.m_280203_(inputs.get(j), slotX + 4, y + SlateMenu.heightMargin + 4);
        }
        boolean cont = true;
        for (int i = 0; i < SlateMenu.slotCount; ++i) {
            int v;
            int h;
            int height = y + SlateMenu.heightMargin + i * SlateMenu.layerHeight + SlateMenu.layerHeight / 2 + (SlateMenu.slotHeight - 9);
            graphics.m_280218_(this.slate, x + slotOffset, height, 192, 24, SlateMenu.slotWidth, SlateMenu.slotHeight);
            if (baseStack.m_41619_() || !cont) continue;
            ItemStack stack = ((SlateMenu)this.f_97732_).m_38853_(i).m_7993_();
            ArrayList<ItemStack> aspects = AlchemyHintItem.getAspects(stack);
            if (aspects.isEmpty()) {
                cont = false;
                continue;
            }
            int blackPins = AlchemyHintItem.getBlackPins(stack);
            int whitePins = AlchemyHintItem.getWhitePins(stack);
            for (int j = 0; j < inputs.size(); ++j) {
                int slotX = x + SlateMenu.widthMargin + j * SlateMenu.layerWidth / inputs.size() + SlateMenu.layerWidth / (2 * inputs.size()) - 10;
                graphics.m_280218_(this.slate, slotX, height, 218, 20, 20, 24);
                if (j >= aspects.size()) continue;
                graphics.m_280203_(aspects.get(j), slotX + 2, height + 3);
            }
            int hintX = x + 155;
            int hintY = height + 2;
            graphics.m_280218_(this.slate, hintX, hintY, 216, 0, 19, 19);
            if (inputs.size() <= 4) {
                for (h = 0; h < 2; ++h) {
                    for (v = 0; v < 2; ++v) {
                        if (blackPins > 0) {
                            graphics.m_280218_(this.slate, hintX + 3 + v * 8, hintY + 3 + h * 8, 198, 50, 6, 6);
                            --blackPins;
                            continue;
                        }
                        if (whitePins > 0) {
                            graphics.m_280218_(this.slate, hintX + 3 + v * 8, hintY + 3 + h * 8, 204, 50, 6, 6);
                            --whitePins;
                            continue;
                        }
                        graphics.m_280218_(this.slate, hintX + 3 + v * 8, hintY + 3 + h * 8, 192, 50, 6, 6);
                    }
                }
                continue;
            }
            for (h = 0; h < 3; ++h) {
                for (v = 0; v < 3; ++v) {
                    if (blackPins > 0) {
                        graphics.m_280218_(this.slate, hintX + 1 + v * 6, hintY + 1 + h * 6, 198, 50, 6, 6);
                        --blackPins;
                        continue;
                    }
                    if (whitePins > 0) {
                        graphics.m_280218_(this.slate, hintX + 1 + v * 6, hintY + 1 + h * 6, 204, 50, 6, 6);
                        --whitePins;
                        continue;
                    }
                    graphics.m_280218_(this.slate, hintX + 1 + v * 6, hintY + 1 + h * 6, 192, 50, 6, 6);
                }
            }
        }
    }

    public void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }
}

