/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.model;

import com.rekindled.embers.RegistryManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class AshenArmorModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation ASHEN_ARMOR_HEAD = new ModelLayerLocation(new ResourceLocation("embers", "ashen_armor"), "head");
    public static final ModelLayerLocation ASHEN_ARMOR_CHEST = new ModelLayerLocation(new ResourceLocation("embers", "ashen_armor"), "chest");
    public static final ModelLayerLocation ASHEN_ARMOR_LEGS = new ModelLayerLocation(new ResourceLocation("embers", "ashen_armor"), "legs");
    public static final ModelLayerLocation ASHEN_ARMOR_FEET = new ModelLayerLocation(new ResourceLocation("embers", "ashen_armor"), "feet");
    public static final Map<EquipmentSlot, AshenArmorModel> ARMOR_MODELS = new EnumMap<EquipmentSlot, AshenArmorModel>(EquipmentSlot.class);
    public static final IClientItemExtensions ARMOR_MODEL_GETTER = new IClientItemExtensions(){

        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
            AshenArmorModel model = ARMOR_MODELS.get(equipmentSlot);
            model.setup(livingEntity, itemStack);
            return model;
        }
    };
    public static CubeDeformation scale = new CubeDeformation(0.1f);
    public double velocity = 0.0;
    public ModelPart cape = null;
    public ModelPart[] gems = new ModelPart[7];

    public AshenArmorModel(ModelPart root, EquipmentSlot slot) {
        super(root);
        if (this.f_102810_.m_233562_("cape")) {
            this.cape = this.f_102810_.m_171324_("cape");
            for (int i = 0; i < this.gems.length; ++i) {
                this.gems[i] = this.cape.m_171324_("cape_gem_" + i);
            }
        }
    }

    public void setup(LivingEntity entity, ItemStack itemStack) {
        block7: {
            if (this.cape == null) break block7;
            if (entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                float partialTicks = Minecraft.m_91087_().getPartialTick();
                double d0 = Mth.m_14139_((double)partialTicks, (double)player.f_36102_, (double)player.f_36105_) - Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
                double d1 = Mth.m_14139_((double)partialTicks, (double)player.f_36103_, (double)player.f_36106_) - Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
                double d2 = Mth.m_14139_((double)partialTicks, (double)player.f_36104_, (double)player.f_36075_) - Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
                float f = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
                double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                if ((f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f)) < 0.0f) {
                    f2 = 0.0f;
                }
                float f4 = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
                this.cape.f_104203_ = (6.0f + f2 / 2.0f + (f1 += Mth.m_14031_((float)(Mth.m_14179_((float)partialTicks, (float)entity.f_19867_, (float)entity.f_19787_) * 6.0f)) * 32.0f * f4)) * ((float)Math.PI / 180);
            } else {
                this.cape.f_104203_ = 0.0f;
            }
            if (itemStack.m_41720_() == RegistryManager.ASHEN_CLOAK.get()) {
                for (int i = 0; i < this.gems.length; ++i) {
                    this.gems[i].f_104207_ = itemStack.m_41784_().m_128441_("gem" + i);
                }
            } else {
                for (int i = 0; i < this.gems.length; ++i) {
                    this.gems[i].f_104207_ = false;
                }
            }
        }
    }

    public static void init(EntityRendererProvider.Context context) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ARMOR_MODELS.put(slot, new AshenArmorModel(switch (slot) {
                case EquipmentSlot.HEAD -> context.m_174023_(ASHEN_ARMOR_HEAD);
                case EquipmentSlot.CHEST -> context.m_174023_(ASHEN_ARMOR_CHEST);
                case EquipmentSlot.LEGS -> context.m_174023_(ASHEN_ARMOR_LEGS);
                default -> context.m_174023_(ASHEN_ARMOR_FEET);
            }, slot));
        }
    }

    public static MeshDefinition createHeadMesh() {
        CubeDeformation scale = new CubeDeformation(0.01f);
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        head.m_171599_("head_1", CubeListBuilder.m_171558_().m_171514_(20, 35).m_171481_(-2.0f, -6.0f, 3.0f, 4.0f, 4.0f, 2.0f), PartPose.f_171404_);
        head.m_171599_("strap_back", CubeListBuilder.m_171558_().m_171514_(36, 32).m_171488_(-4.5f, -1.0f, -0.5f, 9.0f, 2.0f, 1.0f, scale), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)4.0f));
        head.m_171599_("strap_side_1", CubeListBuilder.m_171558_().m_171514_(36, 22).m_171488_(-1.0f, -1.0f, -4.5f, 1.0f, 2.0f, 8.0f, scale), PartPose.m_171419_((float)-3.52f, (float)-4.0f, (float)0.0f));
        head.m_171599_("strap_side_2", CubeListBuilder.m_171558_().m_171514_(36, 22).m_171488_(-1.0f, -1.0f, -4.5f, 1.0f, 2.0f, 8.0f, scale), PartPose.m_171419_((float)4.52f, (float)-4.0f, (float)0.0f));
        head.m_171599_("strap_back_top", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171488_(-1.0f, -4.5f, -0.5f, 2.0f, 5.0f, 1.0f, scale), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)4.0f));
        head.m_171599_("strap_top", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -4.5f, -3.5f, 2.0f, 1.0f, 7.0f, scale), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        head.m_171599_("strap_front", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171488_(-1.0f, -5.5f, -1.5f, 2.0f, 5.0f, 1.0f, scale), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-3.0f));
        head.m_171599_("head_7", CubeListBuilder.m_171558_().m_171514_(22, 50).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.m_171419_((float)1.0f, (float)-5.0f, (float)-4.0f));
        head.m_171599_("head_8", CubeListBuilder.m_171558_().m_171514_(22, 50).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.m_171419_((float)4.0f, (float)-5.0f, (float)-4.0f));
        head.m_171599_("head_9", CubeListBuilder.m_171558_().m_171514_(22, 48).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)2.5f, (float)-6.0f, (float)-4.0f));
        head.m_171599_("head_10", CubeListBuilder.m_171558_().m_171514_(22, 48).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)2.5f, (float)-3.0f, (float)-4.0f));
        head.m_171599_("head_11", CubeListBuilder.m_171558_().m_171514_(22, 50).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-4.0f, (float)-5.0f, (float)-4.0f));
        head.m_171599_("head_12", CubeListBuilder.m_171558_().m_171514_(22, 48).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-2.5f, (float)-6.0f, (float)-4.0f));
        head.m_171599_("head_13", CubeListBuilder.m_171558_().m_171514_(22, 50).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)-5.0f, (float)-4.0f));
        head.m_171599_("head_14", CubeListBuilder.m_171558_().m_171514_(22, 48).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-2.5f, (float)-3.0f, (float)-4.0f));
        return mesh;
    }

    public static MeshDefinition createChestMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition armL = root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition armR = root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_("front_1", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 12.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)-1.5f, (float)0.0873f, (float)-2.8798f, (float)0.0f));
        body.m_171599_("front_2", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 12.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)-1.5f, (float)0.0873f, (float)2.8798f, (float)0.0f));
        body.m_171599_("front_3", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171481_(-2.5f, 0.0f, -1.0f, 5.0f, 10.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.5f, (float)0.0873f, (float)3.1416f, (float)0.0f));
        body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-4.5f, 0.0f, -4.0f, 9.0f, 2.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.3f, (float)0.0f, (float)0.0f));
        armR.m_171599_("shoulder_right", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-3.5f, -4.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.f_171404_);
        armR.m_171599_("glove_right", CubeListBuilder.m_171558_().m_171514_(36, 12).m_171481_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)-1.0f, (float)8.0f, (float)0.0f));
        armL.m_171599_("shoulder_left", CubeListBuilder.m_171558_().m_171514_(16, 54).m_171481_(-1.5f, -4.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.f_171404_);
        armL.m_171599_("glove_left", CubeListBuilder.m_171558_().m_171514_(36, 12).m_171481_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)1.0f, (float)8.0f, (float)0.0f));
        cape.m_171599_("cape_1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 0.0f, -1.0f, 6.0f, 22.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        cape.m_171599_("cape_2", CubeListBuilder.m_171558_().m_171514_(48, 40).m_171481_(-3.0f, 0.0f, -1.0f, 6.0f, 22.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)0.5236f, (float)0.0f));
        cape.m_171599_("cape_3", CubeListBuilder.m_171558_().m_171514_(48, 40).m_171481_(-3.0f, 0.0f, -1.0f, 6.0f, 22.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)-0.5236f, (float)0.0f));
        cape.m_171599_("cape_gem_0", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-1.0f, 16.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)0.5236f, (float)0.0f));
        cape.m_171599_("cape_gem_1", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-1.0f, 10.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)0.5236f, (float)0.0f));
        cape.m_171599_("cape_gem_2", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-1.0f, 4.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)0.5236f, (float)0.0f));
        cape.m_171599_("cape_gem_3", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-1.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        cape.m_171599_("cape_gem_4", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-1.0f, 4.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)-0.5236f, (float)0.0f));
        cape.m_171599_("cape_gem_5", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-1.0f, 10.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)-0.5236f, (float)0.0f));
        cape.m_171599_("cape_gem_6", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-1.0f, 16.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)1.5f, (float)0.2618f, (float)-0.5236f, (float)0.0f));
        return mesh;
    }

    public static MeshDefinition createLegsMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition legL = root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition legR = root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        legL.m_171599_("left_knee", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-2.5f, 1.0f, -2.5f, 5.0f, 5.0f, 5.0f, scale), PartPose.m_171423_((float)0.6f, (float)0.0f, (float)-0.5f, (float)0.0873f, (float)-0.0873f, (float)0.0f));
        legR.m_171599_("right_knee", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-2.5f, 1.0f, -2.5f, 5.0f, 5.0f, 5.0f, scale), PartPose.m_171423_((float)-0.6f, (float)0.0f, (float)-0.5f, (float)0.0873f, (float)0.0873f, (float)0.0f));
        body.m_171599_("left_leg_1", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-2.5f, -5.1867f, -2.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171423_((float)2.1f, (float)13.0f, (float)-0.5f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        body.m_171599_("right_leg_1", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-2.5f, -5.1867f, -2.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171423_((float)-2.1f, (float)13.0f, (float)-0.5f, (float)0.0f, (float)0.1745f, (float)0.0f));
        return mesh;
    }

    public static MeshDefinition createFeetMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition legL = root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition legR = root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        legR.m_171599_("boot_right", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171481_(-2.5f, -6.5f, -2.5f, 5.0f, 6.0f, 5.0f), PartPose.m_171419_((float)-0.1f, (float)13.0f, (float)0.0f));
        legR.m_171599_("toe_right", CubeListBuilder.m_171558_().m_171514_(51, 12).m_171481_(-2.5f, -2.5f, -3.5f, 5.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-0.1f, (float)13.0f, (float)0.0f));
        legL.m_171599_("boot_left", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171481_(-2.5f, -6.5f, -2.5f, 5.0f, 6.0f, 5.0f), PartPose.m_171419_((float)0.1f, (float)13.0f, (float)0.0f));
        legL.m_171599_("toe_left", CubeListBuilder.m_171558_().m_171514_(51, 12).m_171481_(-2.5f, -2.5f, -3.5f, 5.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.1f, (float)13.0f, (float)0.0f));
        return mesh;
    }
}

