/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.network.message;

import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MessageCrystalCellGrowFX {
    public static Random random = new Random();
    public BlockPos pos = BlockPos.f_121853_;
    double capacity = 0.0;

    public MessageCrystalCellGrowFX() {
    }

    public MessageCrystalCellGrowFX(BlockPos pos, double capacity) {
        this.pos = pos;
        this.capacity = capacity;
    }

    public static void encode(MessageCrystalCellGrowFX msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeDouble(msg.capacity);
    }

    public static MessageCrystalCellGrowFX decode(FriendlyByteBuf buf) {
        return new MessageCrystalCellGrowFX(buf.m_130135_(), buf.readDouble());
    }

    public static void handle(MessageCrystalCellGrowFX msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> MessageCrystalCellGrowFX.spawnParticles(msg));
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(MessageCrystalCellGrowFX msg) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double x = (double)msg.pos.m_123341_() + 0.5 + 0.5 * Math.sin(angle);
        double z = (double)msg.pos.m_123343_() + 0.5 + 0.5 * Math.cos(angle);
        double x2 = (double)msg.pos.m_123341_() + 0.5;
        double z2 = (double)msg.pos.m_123343_() + 0.5;
        float layerHeight = 0.25f;
        float numLayers = 2.0f + (float)Math.floor(msg.capacity / 120000.0);
        float height = layerHeight * numLayers;
        for (float i = 0.0f; i < 72.0f; i += 1.0f) {
            float coeff = i / 72.0f;
            level.m_7106_((ParticleOptions)GlowParticleOptions.EMBER_NOMOTION, x * (double)(1.0f - coeff) + x2 * (double)coeff, (double)((float)msg.pos.m_123342_() + (1.0f - coeff) + (height / 2.0f + 1.5f) * coeff), z * (double)(1.0f - coeff) + z2 * (double)coeff, 0.0, 0.0, 0.0);
        }
        level.m_7785_(x, (double)msg.pos.m_123342_() + 0.5, z, (SoundEvent)EmbersSounds.CRYSTAL_CELL_GROW.get(), SoundSource.BLOCKS, 1.0f, 1.0f + random.nextFloat(), false);
    }
}

