/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.network.message;

import com.rekindled.embers.datagen.EmbersSounds;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class MessageItemSound {
    private final int id;
    private final Item item;
    private final SoundEvent sound;
    private final SoundSource source;
    private final boolean repeat;
    private final float volume;
    private final float pitch;

    public MessageItemSound(Entity entity, Item item, SoundEvent sound, SoundSource source, boolean repeat, float volume, float pitch) {
        this(entity.m_19879_(), item, sound, source, repeat, volume, pitch);
    }

    public MessageItemSound(int id, Item item, SoundEvent sound, SoundSource source, boolean repeat, float volume, float pitch) {
        Validate.notNull((Object)sound, (String)"sound", (Object[])new Object[0]);
        this.item = item;
        this.sound = sound;
        this.source = source;
        this.id = id;
        this.repeat = repeat;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(MessageItemSound msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.id);
        buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)msg.item);
        buf.m_236818_((IdMap)BuiltInRegistries.f_256894_, (Object)msg.sound);
        buf.m_130068_((Enum)msg.source);
        buf.writeBoolean(msg.repeat);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
    }

    public static MessageItemSound decode(FriendlyByteBuf buf) {
        return new MessageItemSound(buf.m_130242_(), (Item)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_), (SoundEvent)buf.m_236816_((IdMap)BuiltInRegistries.f_256894_), (SoundSource)buf.m_130066_(SoundSource.class), buf.readBoolean(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(MessageItemSound msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Entity patt2224$temp = Minecraft.m_91087_().f_91073_.m_6815_(msg.id);
                if (patt2224$temp instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)patt2224$temp;
                    EmbersSounds.playItemSoundClient(entity, msg.item, msg.sound, msg.source, msg.repeat, msg.volume, msg.pitch);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

