/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.util.EmbersColors;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public class SparkParticleOptions
implements ParticleOptions {
    public static final float MIN_SCALE = 0.01f;
    public static final float MAX_SCALE = 4.0f;
    protected final ResourceLocation colorId;
    protected final Vector3f color;
    protected final float scale;
    public static final SparkParticleOptions EMBER = new SparkParticleOptions(EmbersColors.EMBER_ID, 2.0f);
    public static final Codec<SparkParticleOptions> CODEC = RecordCodecBuilder.create(p_175793_ -> p_175793_.group((App)ResourceLocation.f_135803_.fieldOf("color_id").forGetter(p_175797_ -> p_175797_.colorId), (App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(p_175797_ -> p_175797_.color), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_175795_ -> Float.valueOf(p_175795_.scale))).apply((Applicative)p_175793_, SparkParticleOptions::new));
    public static final ParticleOptions.Deserializer<SparkParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<SparkParticleOptions>(){

        public SparkParticleOptions fromCommand(ParticleType<SparkParticleOptions> p_123689_, StringReader p_123690_) throws CommandSyntaxException {
            Vector3f vector3f = SparkParticleOptions.readVector3f(p_123690_);
            p_123690_.expect(' ');
            float f = p_123690_.readFloat();
            return new SparkParticleOptions(vector3f, f);
        }

        public SparkParticleOptions fromNetwork(ParticleType<SparkParticleOptions> p_123692_, FriendlyByteBuf p_123693_) {
            return new SparkParticleOptions(p_123693_.m_130281_(), SparkParticleOptions.readVector3f(p_123693_), p_123693_.readFloat());
        }
    };

    public SparkParticleOptions(ResourceLocation pColorId, Vector3f pColor, float pScale) {
        this.colorId = pColorId;
        this.color = pColor;
        this.scale = pScale;
    }

    public SparkParticleOptions(Vector3f pColor, float pScale) {
        this(EmbersColors.CUSTOM_ID, pColor, pScale);
    }

    public SparkParticleOptions(ResourceLocation pColorId, float pScale) {
        this(pColorId, EmbersColors.EMBER, pScale);
    }

    public static Vector3f readVector3f(StringReader pStringInput) throws CommandSyntaxException {
        pStringInput.expect(' ');
        float f = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f1 = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f2 = pStringInput.readFloat();
        return new Vector3f(f, f1, f2);
    }

    public static Vector3f readVector3f(FriendlyByteBuf pBuffer) {
        return new Vector3f(pBuffer.readFloat(), pBuffer.readFloat(), pBuffer.readFloat());
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        pBuffer.m_130085_(this.colorId);
        pBuffer.writeFloat(this.color.x());
        pBuffer.writeFloat(this.color.y());
        pBuffer.writeFloat(this.color.z());
        pBuffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), Float.valueOf(this.scale));
    }

    public Vector3f getColor() {
        return EmbersAPI.getColor(this.colorId, this.color);
    }

    public float getScale() {
        return this.scale;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)RegistryManager.SPARK_PARTICLE.get();
    }
}

