/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.power;

import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class DefaultEmberItemCapability
implements IEmberCapability {
    @Nonnull
    public ItemStack stack;
    public final LazyOptional<?> capOptional;
    double ember = 0.0;
    double capacity = 0.0;

    public DefaultEmberItemCapability(@Nonnull ItemStack stack, double capacity) {
        this.stack = stack;
        this.setEmberCapacity(capacity);
        this.capOptional = LazyOptional.of(() -> this);
        CompoundTag BEnbt = stack.m_41737_("BlockEntityTag");
        if (BEnbt != null) {
            this.setEmber(BEnbt.m_128459_("embers:ember"));
            this.setEmberCapacity(BEnbt.m_128459_("embers:ember_capacity"));
        }
    }

    @Override
    public void invalidate() {
        this.capOptional.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public double getEmber() {
        if (this.stack.m_41619_()) {
            return 0.0;
        }
        return this.stack.m_41698_("ForgeCaps").m_128459_("embers:ember");
    }

    @Override
    public double getEmberCapacity() {
        if (this.stack.m_41619_()) {
            return 0.0;
        }
        return this.stack.m_41698_("ForgeCaps").m_128459_("embers:ember_capacity");
    }

    @Override
    public void setEmber(double value) {
        this.ember = value;
        this.stack.m_41698_("ForgeCaps").m_128347_("embers:ember", value);
    }

    @Override
    public void setEmberCapacity(double value) {
        this.capacity = value;
        this.stack.m_41698_("ForgeCaps").m_128347_("embers:ember_capacity", value);
    }

    @Override
    public double addAmount(double value, boolean doAdd) {
        double ember = this.getEmber();
        double capacity = this.getEmberCapacity();
        double added = Math.min(capacity - ember, value);
        double newEmber = ember + added;
        if (doAdd) {
            if (newEmber != ember) {
                this.onContentsChanged();
            }
            this.setEmber(ember + added);
        }
        return added;
    }

    @Override
    public double removeAmount(double value, boolean doRemove) {
        double ember = this.getEmber();
        double removed = Math.min(ember, value);
        double newEmber = ember - removed;
        if (doRemove) {
            if (newEmber != ember) {
                this.onContentsChanged();
            }
            this.setEmber(ember - removed);
        }
        return removed;
    }

    @Override
    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128347_("embers:ember", this.ember);
        nbt.m_128347_("embers:ember_capacity", this.capacity);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.writeToNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("embers:ember")) {
            this.ember = nbt.m_128459_("embers:ember");
        }
        if (nbt.m_128441_("embers:ember_capacity")) {
            this.capacity = nbt.m_128459_("embers:ember_capacity");
        }
    }

    @Override
    public void onContentsChanged() {
    }
}

