/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.augment.IAugment;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class AugmentIngredient
extends AbstractIngredient {
    private final Ingredient base;
    private final IAugment augment;
    private final int level;
    private ItemStack[] augmentedMatchingStacks;
    private IntList packedMatchingStacks;
    private boolean inverted;

    public AugmentIngredient(Ingredient base, IAugment augment, int level, boolean inverted) {
        this.base = base;
        this.augment = augment;
        this.level = level;
        this.inverted = inverted;
    }

    public static AugmentIngredient of(Ingredient base, IAugment augment, int level, boolean inverted) {
        return new AugmentIngredient(base, augment, level, inverted);
    }

    public static AugmentIngredient of(Ingredient base, IAugment augment, boolean inverted) {
        return new AugmentIngredient(base, augment, 1, inverted);
    }

    public static AugmentIngredient of(Ingredient base, IAugment augment, int level) {
        return new AugmentIngredient(base, augment, level, false);
    }

    public static AugmentIngredient of(Ingredient base, IAugment augment) {
        return new AugmentIngredient(base, augment, 1, false);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        return this.base.test(stack) && AugmentUtil.hasHeat(stack) && this.inverted ^ AugmentUtil.getAugmentLevel(stack, this.augment) >= this.level;
    }

    public ItemStack[] m_43908_() {
        if (this.augmentedMatchingStacks == null) {
            ItemStack[] items = this.base.m_43908_();
            this.augmentedMatchingStacks = new ItemStack[items.length];
            for (int i = 0; i < items.length; ++i) {
                ItemStack stack = items[i].m_41777_();
                if (this.inverted) {
                    AugmentUtil.setHeat(stack, 0.0f);
                } else {
                    AugmentUtil.setLevel(stack, AugmentUtil.getLevel(stack) + this.level);
                    AugmentUtil.addAugment(stack, ItemStack.f_41583_, this.augment);
                    AugmentUtil.setAugmentLevel(stack, this.augment, this.level);
                }
                this.augmentedMatchingStacks[i] = stack;
            }
        }
        return this.augmentedMatchingStacks;
    }

    public boolean m_43947_() {
        return this.base.m_43947_();
    }

    public boolean isSimple() {
        return this.base.isSimple();
    }

    protected void invalidate() {
        super.invalidate();
        this.augmentedMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList m_43931_() {
        if (this.packedMatchingStacks == null || this.checkInvalidation()) {
            this.markValid();
            ItemStack[] matchingStacks = this.m_43908_();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (ItemStack stack : matchingStacks) {
                this.packedMatchingStacks.add(StackedContents.m_36496_((ItemStack)stack));
            }
            this.packedMatchingStacks.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(Serializer.INSTANCE).toString());
        json.add("base", this.base.m_43942_());
        json.addProperty("augment", this.augment.getName().toString());
        json.addProperty("level", (Number)this.level);
        if (this.inverted) {
            json.addProperty("inverted", Boolean.valueOf(this.inverted));
        }
        return json;
    }

    public IIngredientSerializer<AugmentIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<AugmentIngredient> {
        public static final IIngredientSerializer<AugmentIngredient> INSTANCE = new Serializer();

        public AugmentIngredient parse(JsonObject json) {
            Ingredient base = Ingredient.m_288218_((JsonElement)json.get("base"), (boolean)false);
            IAugment augment = AugmentUtil.getAugment(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"augment")));
            int level = GsonHelper.m_13927_((JsonObject)json, (String)"level");
            boolean inverted = false;
            if (json.has("inverted")) {
                inverted = GsonHelper.m_13912_((JsonObject)json, (String)"inverted");
            }
            return new AugmentIngredient(base, augment, level, inverted);
        }

        public AugmentIngredient parse(FriendlyByteBuf buffer) {
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            IAugment augment = AugmentUtil.getAugment(buffer.m_130281_());
            int level = buffer.readInt();
            boolean inverted = buffer.readBoolean();
            return new AugmentIngredient(base, augment, level, inverted);
        }

        public void write(FriendlyByteBuf buffer, AugmentIngredient ingredient) {
            ingredient.base.m_43923_(buffer);
            buffer.m_130085_(ingredient.augment.getName());
            buffer.writeInt(ingredient.level);
            buffer.writeBoolean(ingredient.inverted);
        }
    }
}

