/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.BoilingRecipe;
import com.rekindled.embers.recipe.FluidIngredient;
import com.rekindled.embers.util.FluidOutput;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BoilingRecipeBuilder {
    public ResourceLocation id;
    public FluidIngredient input;
    public FluidOutput output;

    public static BoilingRecipeBuilder create(FluidStack fluidStack) {
        BoilingRecipeBuilder builder = new BoilingRecipeBuilder();
        builder.output = new FluidOutput(fluidStack);
        builder.id = ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid());
        return builder;
    }

    public static BoilingRecipeBuilder create(Fluid fluid, int amount) {
        return BoilingRecipeBuilder.create(new FluidStack(fluid, amount));
    }

    public static BoilingRecipeBuilder create(TagKey<Fluid> tag, int amount) {
        BoilingRecipeBuilder builder = new BoilingRecipeBuilder();
        builder.output = new FluidOutput(tag, amount);
        builder.id = tag.f_203868_();
        return builder;
    }

    public BoilingRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public BoilingRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public BoilingRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public BoilingRecipeBuilder input(FluidIngredient fluid) {
        this.input = fluid;
        return this;
    }

    public BoilingRecipeBuilder input(Fluid fluid, int amount) {
        this.input(FluidIngredient.of(fluid, amount));
        return this;
    }

    public BoilingRecipeBuilder input(FluidStack stack) {
        this.input(FluidIngredient.of(stack));
        return this;
    }

    public BoilingRecipeBuilder input(TagKey<Fluid> fluid, int amount) {
        this.input(FluidIngredient.of(fluid, amount));
        return this;
    }

    public BoilingRecipeBuilder input(FluidIngredient ... ingredients) {
        this.input(FluidIngredient.of(ingredients));
        return this;
    }

    public BoilingRecipeBuilder output(FluidStack output) {
        this.output = new FluidOutput(output);
        return this;
    }

    public BoilingRecipeBuilder output(Fluid fluid, int amount) {
        this.output(new FluidStack(fluid, amount));
        return this;
    }

    public BoilingRecipeBuilder output(TagKey<Fluid> tag, int amount) {
        this.output = new FluidOutput(tag, amount);
        return this;
    }

    public BoilingRecipe build() {
        return new BoilingRecipe(this.id, this.input, this.output);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final BoilingRecipe recipe;

        public Finished(BoilingRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.recipe.input.serialize());
            json.add("output", (JsonElement)this.recipe.output.toJson());
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.BOILING_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

