/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.CatalysisCombustionRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CatalysisCombustionRecipeBuilder {
    public ResourceLocation id;
    public Ingredient ingredient;
    public Ingredient machine;
    public int burnTime;
    public double multiplier;

    public static CatalysisCombustionRecipeBuilder create(Ingredient ingredient) {
        CatalysisCombustionRecipeBuilder builder = new CatalysisCombustionRecipeBuilder();
        builder.ingredient = ingredient;
        return builder;
    }

    public static CatalysisCombustionRecipeBuilder create(TagKey<Item> tag) {
        CatalysisCombustionRecipeBuilder builder = CatalysisCombustionRecipeBuilder.create(Ingredient.m_204132_(tag));
        builder.id = tag.f_203868_();
        return builder;
    }

    public static CatalysisCombustionRecipeBuilder create(ItemStack itemStack) {
        CatalysisCombustionRecipeBuilder builder = CatalysisCombustionRecipeBuilder.create(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}));
        builder.id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return builder;
    }

    public static CatalysisCombustionRecipeBuilder create(Item item) {
        return CatalysisCombustionRecipeBuilder.create(new ItemStack((ItemLike)item));
    }

    public CatalysisCombustionRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public CatalysisCombustionRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public CatalysisCombustionRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public CatalysisCombustionRecipeBuilder catalysis() {
        this.machine = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.CATALYSIS_CHAMBER_ITEM.get()});
        return this;
    }

    public CatalysisCombustionRecipeBuilder combustion() {
        this.machine = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.COMBUSTION_CHAMBER_ITEM.get()});
        return this;
    }

    public CatalysisCombustionRecipeBuilder burnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public CatalysisCombustionRecipeBuilder multiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public CatalysisCombustionRecipe build() {
        return new CatalysisCombustionRecipe(this.id, this.ingredient, this.machine, this.burnTime, this.multiplier);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final CatalysisCombustionRecipe recipe;

        public Finished(CatalysisCombustionRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.recipe.ingredient.m_43942_());
            json.add("machine", this.recipe.machine.m_43942_());
            json.addProperty("burn_time", (Number)this.recipe.burnTime);
            json.addProperty("multiplier", (Number)this.recipe.multiplier);
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.CATALYSIS_COMBUSTION_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

