/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.item.IInflictorGemHolder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GemUnsocketRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;

    public GemUnsocketRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack cloak = ItemStack.f_41583_;
        int cloaks = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IInflictorGemHolder) {
                if (((IInflictorGemHolder)stack.m_41720_()).getAttachedGemCount(stack) > 0) {
                    cloak = stack;
                }
                ++cloaks;
                continue;
            }
            return false;
        }
        return !cloak.m_41619_() && cloaks == 1 && container.m_6643_() >= ((IInflictorGemHolder)cloak.m_41720_()).getAttachedGemCount(cloak);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack capeStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (container.m_8020_(i).m_41619_() || !(container.m_8020_(i).m_41720_() instanceof IInflictorGemHolder)) continue;
            capeStack = container.m_8020_(i).m_41777_();
        }
        if (!capeStack.m_41619_()) {
            ((IInflictorGemHolder)capeStack.m_41720_()).clearGems(capeStack);
        }
        return capeStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList gems = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        int index = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof IInflictorGemHolder)) continue;
            for (ItemStack gem : ((IInflictorGemHolder)stack.m_41720_()).getAttachedGems(stack)) {
                if (gem.m_41619_()) continue;
                gems.set(index, (Object)gem);
                ++index;
            }
        }
        return gems;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)RegistryManager.ASHEN_CLOAK.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_271738_() {
        return false;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.EQUIPMENT;
    }

    public static class Serializer
    implements RecipeSerializer<GemUnsocketRecipe> {
        public GemUnsocketRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new GemUnsocketRecipe(recipeId);
        }

        @Nullable
        public GemUnsocketRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new GemUnsocketRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, GemUnsocketRecipe recipe) {
        }
    }
}

