/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.api.augment.AugmentUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class HeatIngredient
extends AbstractIngredient {
    private final Ingredient base;
    private ItemStack[] heatedMatchingStacks;
    private IntList packedMatchingStacks;
    private boolean inverted;

    public HeatIngredient(Ingredient base, boolean inverted) {
        this.base = base;
        this.inverted = inverted;
    }

    public static HeatIngredient of(Ingredient base, boolean inverted) {
        return new HeatIngredient(base, inverted);
    }

    public static HeatIngredient of(Ingredient base) {
        return new HeatIngredient(base, false);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        return this.base.test(stack) && this.inverted ^ AugmentUtil.hasHeat(stack);
    }

    public ItemStack[] m_43908_() {
        if (!this.inverted) {
            if (this.heatedMatchingStacks == null) {
                ItemStack[] items = this.base.m_43908_();
                this.heatedMatchingStacks = new ItemStack[items.length];
                for (int i = 0; i < items.length; ++i) {
                    ItemStack stack = items[i].m_41777_();
                    AugmentUtil.setHeat(stack, 0.0f);
                    this.heatedMatchingStacks[i] = stack;
                }
            }
            return this.heatedMatchingStacks;
        }
        return this.base.m_43908_();
    }

    public boolean m_43947_() {
        return this.base.m_43947_();
    }

    public boolean isSimple() {
        return this.base.isSimple();
    }

    protected void invalidate() {
        super.invalidate();
        this.heatedMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList m_43931_() {
        if (!this.inverted) {
            if (this.packedMatchingStacks == null || this.checkInvalidation()) {
                this.markValid();
                ItemStack[] matchingStacks = this.m_43908_();
                this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
                for (ItemStack stack : matchingStacks) {
                    this.packedMatchingStacks.add(StackedContents.m_36496_((ItemStack)stack));
                }
                this.packedMatchingStacks.sort(IntComparators.NATURAL_COMPARATOR);
            }
            return this.packedMatchingStacks;
        }
        return this.base.m_43931_();
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(Serializer.INSTANCE).toString());
        json.add("base", this.base.m_43942_());
        if (this.inverted) {
            json.addProperty("inverted", Boolean.valueOf(this.inverted));
        }
        return json;
    }

    public IIngredientSerializer<HeatIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<HeatIngredient> {
        public static final IIngredientSerializer<HeatIngredient> INSTANCE = new Serializer();

        public HeatIngredient parse(JsonObject json) {
            Ingredient base = Ingredient.m_288218_((JsonElement)json.get("base"), (boolean)false);
            boolean inverted = false;
            if (json.has("inverted")) {
                inverted = GsonHelper.m_13912_((JsonObject)json, (String)"inverted");
            }
            return new HeatIngredient(base, inverted);
        }

        public HeatIngredient parse(FriendlyByteBuf buffer) {
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            boolean inverted = buffer.readBoolean();
            return new HeatIngredient(base, inverted);
        }

        public void write(FriendlyByteBuf buffer, HeatIngredient ingredient) {
            ingredient.base.m_43923_(buffer);
            buffer.writeBoolean(ingredient.inverted);
        }
    }
}

