/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.FluidIngredient;
import com.rekindled.embers.recipe.StampingRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class StampingRecipeBuilder {
    public ResourceLocation id;
    public Ingredient stamp;
    public Ingredient input = Ingredient.f_43901_;
    public FluidIngredient fluid = FluidIngredient.EMPTY;
    public Either<ItemStack, StampingRecipe.TagAmount> output;

    public static StampingRecipeBuilder create(ItemStack itemStack) {
        StampingRecipeBuilder builder = new StampingRecipeBuilder();
        builder.output = Either.left((Object)itemStack);
        builder.id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return builder;
    }

    public static StampingRecipeBuilder create(Item item) {
        return StampingRecipeBuilder.create(new ItemStack((ItemLike)item));
    }

    public static StampingRecipeBuilder create(TagKey<Item> tag, int amount) {
        StampingRecipeBuilder builder = new StampingRecipeBuilder();
        builder.output = Either.right((Object)new StampingRecipe.TagAmount(tag, amount));
        builder.id = tag.f_203868_();
        return builder;
    }

    public static StampingRecipeBuilder create(TagKey<Item> tag) {
        return StampingRecipeBuilder.create(tag, 1);
    }

    public StampingRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public StampingRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public StampingRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public StampingRecipeBuilder stamp(Ingredient stamp) {
        this.stamp = stamp;
        return this;
    }

    public StampingRecipeBuilder stamp(ItemLike ... stamp) {
        this.stamp(Ingredient.m_43929_((ItemLike[])stamp));
        return this;
    }

    public StampingRecipeBuilder stamp(TagKey<Item> tag) {
        this.stamp(Ingredient.m_204132_(tag));
        return this;
    }

    public StampingRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public StampingRecipeBuilder input(ItemLike ... input) {
        this.input(Ingredient.m_43929_((ItemLike[])input));
        return this;
    }

    public StampingRecipeBuilder input(TagKey<Item> tag) {
        this.input(Ingredient.m_204132_(tag));
        return this;
    }

    public StampingRecipeBuilder fluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public StampingRecipeBuilder fluid(Fluid fluid, int amount) {
        this.fluid(FluidIngredient.of(fluid, amount));
        return this;
    }

    public StampingRecipeBuilder fluid(FluidStack stack) {
        this.fluid(FluidIngredient.of(stack));
        return this;
    }

    public StampingRecipeBuilder fluid(TagKey<Fluid> fluid, int amount) {
        this.fluid(FluidIngredient.of(fluid, amount));
        return this;
    }

    public StampingRecipeBuilder fluid(FluidIngredient ... ingredients) {
        this.fluid(FluidIngredient.of(ingredients));
        return this;
    }

    public StampingRecipe build() {
        return new StampingRecipe(this.id, this.stamp, this.input, this.fluid, this.output);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final StampingRecipe recipe;

        public Finished(StampingRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            JsonObject outputJson = new JsonObject();
            if (this.recipe.output.right().isPresent()) {
                outputJson.addProperty("tag", ((StampingRecipe.TagAmount)this.recipe.output.right().get()).tag.f_203868_().toString());
                int count = ((StampingRecipe.TagAmount)this.recipe.output.right().get()).amount;
                if (count > 1) {
                    outputJson.addProperty("count", (Number)count);
                }
            } else {
                outputJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)((ItemStack)this.recipe.output.left().get()).m_41720_()).toString());
                int count = ((ItemStack)this.recipe.output.left().get()).m_41613_();
                if (count > 1) {
                    outputJson.addProperty("count", (Number)count);
                }
            }
            json.add("output", (JsonElement)outputJson);
            json.add("stamp", this.recipe.stamp.m_43942_());
            if (!this.recipe.input.m_43947_()) {
                json.add("input", this.recipe.input.m_43942_());
            }
            if (this.recipe.fluid != FluidIngredient.EMPTY) {
                json.add("fluid", this.recipe.fluid.serialize());
            }
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.STAMPING_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

