/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.upgrade;

import com.rekindled.embers.api.event.HeatCoilVisualEvent;
import com.rekindled.embers.api.event.UpgradeEvent;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.blockentity.HearthCoilBlockEntity;
import com.rekindled.embers.upgrade.DefaultUpgradeProvider;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3f;

public class AtmosphericBellowsUpgrade
extends DefaultUpgradeProvider {
    public AtmosphericBellowsUpgrade(BlockEntity tile) {
        super(new ResourceLocation("embers", "atmospheric_bellows"), tile);
    }

    @Override
    public int getPriority() {
        return -80;
    }

    @Override
    public int getLimit(BlockEntity tile) {
        return tile instanceof HearthCoilBlockEntity ? 1 : 0;
    }

    @Override
    public double getSpeed(BlockEntity tile, double speed, int distance, int count) {
        return 2.0;
    }

    @Override
    public <T> T getOtherParameter(BlockEntity tile, String type, T value, int distance, int count) {
        if (type.equals("recipe_type") && value instanceof RecipeType) {
            return (T)RecipeType.f_44109_;
        }
        return value;
    }

    @Override
    public void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
        if (event instanceof HeatCoilVisualEvent) {
            HeatCoilVisualEvent visualEvent = (HeatCoilVisualEvent)event;
            Vector3f color = visualEvent.getColor();
            visualEvent.setColor(new Vector3f(color.z, color.y, color.x));
            visualEvent.setParticles((int)((double)visualEvent.getParticles() * 1.5));
        }
    }
}

